package Partner::DSP::Rule;

use qbit;
use base qw(QBit::Class);

use Partner::DSP::Rule::Filter;
use Partner::DSP::Rule::Part;

my @parts = (
    qw(
      available_dsps
      default_dsps
      turn_on_dsp
      dsps_field_validation
      dsps_field_edit
      )
);

__PACKAGE__->mk_ro_accessors(@parts);

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    my %arg_names = map {$_ => 1} keys(%$self);

    for my $part (@parts) {
        if ($part eq 'dsps_field_validation') {
            $self->{$part} //= Partner::DSP::Rule::Part->new(sub => sub { });
        } else {
            $self->{$part} //=
              Partner::DSP::Rule::Part->new(sub => sub {limit => Partner::DSP::Rule::Filter->identity()});
        }
        throw Exception "Partner::DSP::Rule::Part expected for $part"
          unless blessed($self->{$part}) && $self->{$part}->isa('Partner::DSP::Rule::Part');
        delete $arg_names{$part};
    }

    throw Exception "Unexpected args in Partner::DSP::Rule constructor: " . join(', ', keys(%arg_names))
      if keys(%arg_names) > 0;
}

1;
