package Partner::DSP::Rule::Filter;

use qbit;
use base qw(QBit::Class);

sub init {
    my ($self) = @_;

    $self->SUPER::init();
}

sub to_model_filter {
    my ($self) = @_;

    return $self->{inner};
}

sub identity {
    my ($class) = @_;

    return $class->new(identity_filter => 1);
}

sub zero {
    my ($class) = @_;

    return $class->new(zero_filter => 1);
}

sub is_identity {
    my ($self) = @_;

    return !!$self->{identity_filter};
}

sub is_zero {
    my ($self) = @_;

    return !!$self->{zero_filter};
}

1;
