package Partner::DSP::Rule::Filter::And;

use qbit;
use base qw(Partner::DSP::Rule::Filter);

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{inner} //= [];
}

sub and {
    my ($self, $new_filter) = @_;

    return if $self->is_zero;

    if (blessed($new_filter) && $new_filter->isa('Partner::DSP::Rule::Filter')) {
        return if $new_filter->is_identity;

        if ($new_filter->is_zero) {
            $self->{inner}           = [];
            $self->{identity_filter} = 0;
            $self->{zero_filter}     = 1;
            return;
        }

        push @{$self->{inner}}, $new_filter->to_model_filter();
    } else {
        push @{$self->{inner}}, $new_filter;
    }

    $self->{identity_filter} = 0;

    return;
}

sub to_model_filter {
    my ($self) = @_;

    return [AND => $self->{inner}];
}

1;
