package Partner::DSP::Rule::Filter::Or;

use qbit;
use base qw(Partner::DSP::Rule::Filter);

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{inner} //= [];
}

sub or {
    my ($self, $new_filter) = @_;

    return if $self->is_identity;

    if (blessed($new_filter) && $new_filter->isa('Partner::DSP::Rule::Filter')) {
        return if $new_filter->is_zero;

        if ($new_filter->is_identity) {
            $self->{inner}           = [];
            $self->{zero_filter}     = 0;
            $self->{identity_filter} = 1;
            return;
        }

        push @{$self->{inner}}, $new_filter->to_model_filter();
    } else {
        push @{$self->{inner}}, $new_filter;
    }

    $self->{zero_filter} = 0;

    return;
}

sub to_model_filter {
    my ($self) = @_;

    return [OR => $self->{inner}];
}

1;
