package Partner::DSP::RuleSet;

use qbit;
use base qw(QBit::Class);

use Partner::DSP::Rule;
use Partner::DSP::Rule::Filter::Or;
use Partner::DSP::Rule::Filter::And;

__PACKAGE__->mk_ro_accessors(
    qw(
      rules
      )
);

sub init {
    my ($self) = @_;

    $self->SUPER::init();
}

sub add_rule {
    my ($self, $rule) = @_;

    push @{$self->rules}, $rule;
}

# In fact there are different dependencies for different types of objects
# Example: native and rewarded blocks has constant show_video value
# So this method should also depend on object instance (dependencies for building dependencies?)
# (or should there be another method that filters dependencies? fix_template? :( )
sub build_dependencies {
    my ($self, $part_name) = @_;

    if ($part_name eq 'default_dsps') {
        my $available = $self->_build_deps('available_dsps');

        my $default = $self->_build_deps('default_dsps');

        for my $key (keys(%$available)) {
            $default->{$key} = array_uniq(@{$default->{$key}}, @{$available->{$key}});
        }

        return $default;
    } else {
        return $self->_build_deps($part_name);
    }
}

sub build_filter {
    my ($self, $method, $block, $page) = @_;

    if ($method eq 'default_dsps') {
        my $available = $self->_build_filter('available_dsps', $block, $page,);

        my $default = $self->_build_filter('default_dsps', $block, $page,);

        $default->and($available);

        return $default;
    } else {
        return $self->_build_filter($method, $block, $page,);
    }
}

sub validate_dsp_list {
    my ($self, $block, $dsps) = @_;

    for my $rule (@{$self->rules}) {
        $rule->dsps_field_validation->sub->($block, $dsps);
    }
}

sub edit_dsp_list {
    my ($self, $old_block, $opts) = @_;

    for my $rule (@{$self->rules}) {
        if (grep {exists($opts->{$_})} @{$rule->dsps_field_edit->depends_on->{block}}) {
            $rule->dsps_field_edit->sub->($old_block, $opts);
        }
    }
}

sub _build_deps {
    my ($self, $rule_accessor_name) = @_;

    my %deps;

    for my $rule (@{$self->rules}) {
        my $rule_depends = $rule->$rule_accessor_name->depends_on;
        for my $key (keys(%$rule_depends)) {
            $deps{$key} = array_uniq(@{$deps{$key}}, @{$rule_depends->{$key}});
        }
    }

    return \%deps;
}

sub _build_filter {
    my ($self, $rule_accessor_name, @args) = @_;

    my $extend_filter = Partner::DSP::Rule::Filter::Or->zero();
    my $limit_filter  = Partner::DSP::Rule::Filter::And->identity();

    for my $rule (@{$self->rules}) {
        my ($type, $one_more_filter) = $rule->$rule_accessor_name->sub->(@args);
        if ($type eq 'extend') {
            $extend_filter->or($one_more_filter);
        } elsif ($type eq 'limit') {
            $limit_filter->and($one_more_filter);
        } else {
            throw Exception 'Wrong filter type: ' . $type;
        }
    }

    $limit_filter->and($extend_filter) unless $extend_filter->is_zero;

    return $limit_filter;
}

1;
