package Partner::Filters;

use qbit;

use base qw(Exporter);

our @EXPORT = qw(
  get_filters_not_rewarded_mobile_blocks
  get_filters_not_overlay_instream_blocks
  get_filters_not_adaptive_banner_mobile_blocks
  get_filters_and
  );

our @EXPORT_OK = @EXPORT;

use PiConstants qw($OVERLAY_TYPES);

sub get_filters_not_rewarded_mobile_blocks {
    return {
        sub_filter => sub {
            my ($model, $block) = @_;

            return defined($block->{'block_type'}) ? $block->{'block_type'} ne 'rewarded' : TRUE;
        },
        model_filter => ['block_type', '<>', 'rewarded'],
    };
}

sub get_filters_not_adaptive_banner_mobile_blocks {
    return {
        sub_filter => sub {
            my ($model, $block) = @_;

            return defined($block->{'block_type'}) ? $block->{'block_type'} ne 'adaptive_banner' : TRUE;
        },
        model_filter => ['block_type', '<>', 'adaptive_banner'],
    };
}

sub get_filters_not_overlay_instream_blocks {
    return {
        sub_filter => sub {
            my ($model, $block) = @_;

            return defined($block->{'type'}) ? !$OVERLAY_TYPES->{$block->{'type'}} : TRUE;
        },
        model_filter => ['type', '<>', [sort keys %$OVERLAY_TYPES]],
    };
}

sub get_filters_and {
    my ($filters) = @_;

    return $filters unless 'ARRAY' eq ref $filters;

    my $applicable_to_sub_filter = sub {
        my ($model, $obj) = @_;
        my $is_applicable = TRUE;
        for my $filter (@$filters) {
            $is_applicable &&= $filter->{'sub_filter'}->($model, $obj);
        }
        return $is_applicable;
    };
    return {
        'sub_filter'   => $applicable_to_sub_filter,
        'model_filter' => ['AND', [map {$_->{'model_filter'}} @$filters]],
    };
}

TRUE;
