package PiConstants;

use qbit;

use base qw/ Exporter /;

use lib::abs;

use constant RETAIL              => 0;
use constant REALTY              => 1;
use constant TRANSPORT           => 2;
use constant OUTDOOR_ADVERTISING => 1;

our @EXPORT_OK = qw(
  $APP_TYPES
  $OS_ID_ANDROID
  $OS_ID_IOS
  $OS_ID_WIN
  $OS_ID_OTHER
  $AUTHORIZATION_USER_FIELDS
  $OWNERS_USER_FIELDS

  $DEFAULT_HTTP_TIMEOUT
  $DEFAULT_HTTP_ATTEMPTS
  $DEFAULT_HTTP_DELAY

  $DIRECT_PLACE_ID
  $DIRECT_PLACE_ID_E
  $STAT_STRIPE_PLACE_IDS
  $STAT_MARKET_API_PLACE_ID
  $STAT_MARKET_PLACE_ID
  $STAT_PREMIUM_PLACE_ID
  $STAT_MCB_PLACE_IDS

  $AGGR_TUTBY
  $PAGE_KEYS_TRANSFORM
  $PARTNERS_MAIL
  $PARTNERS_TEST_MAIL
  $PARTNER2_CRON_MAIL
  $PARTNERS_INTERNAL_ACCESS_REQUESTS_MAIL
  $SUPPORT_MAIL
  $INTERNATIONAL_SUPPORT_MAIL
  $NOTIFICATIONS_MAIL
  $NOTIFICATIONS_YAS_MAIL
  $PARTNER_MANAGERS_MAIL
  $DSP_MAIL
  $DOCS_MAIL
  $DOCS_PROJECT_MAIL
  $DOCS_UA_MAIL
  $START_STOP_MAIL
  $STOP_MOBILE_MAIL
  $MODERATION_MAIL
  $DEVNULL_MAIL
  $TUTBY_COP_MAIL
  $PARTNER2_IDM_MAIL
  $COMMON_OFFER_DOCS
  $CONTRACT_OFFER_ERROR_MAIL
  $PARTNER2_COMMON_OFFER_ERRORS
  $MANAGERS_MAILING_LIST_FOR_FOCUS_DOMAINS
  $PARTNER_DSP_MONITORING_MAIL
  $GROUP_LEADER_TO_WORK_WITH_INTERNAL_SERVICES
  $SENIOR_MANAGER_FOR_DOCUMENT_PROCESSING_MAIL
  $DEPARTMENT_HEAD_PI
  $DEPARTMENT_HEAD_PI_MAIL
  $DEV_GROUP_HEAD_PI
  $RESPONSIBLE_TEST_ENGINEER_PI
  @DSP_MODE
  $DSP_MEDIA_TYPE_ID
  $DSP_VIDEO_TYPE_ID
  $DSP_MOBILE_TYPE_ID
  $DSP_NATIVE_TYPE_ID
  $DSP_BANNER_FORMAT_ID
  $DSP_NATIVE_FORMAT_ID
  $DSP_VIDEO_FORMAT_ID
  $DSP_FORMAT_TO_TYPE_MAP
  $DSP_DIRECT_ID
  $DSP_AWAPS_ID
  $DSP_OWN_ADV_ID
  $DSP_UNSOLD_ID
  $DSP_AWAPS_ID
  $DSP_AWAPS_MOBILE_ID
  $DSP_CRITEO_NATIVE
  $VIDEO_INTERSTITIAL_MOBILE_ID
  @VIDEO_INTERSTITIAL_DSPS
  @VIDEO_AWAPS_DSPS
  @VIDEO_BANNER_DSPS
  @VIDEO_DEFAULT_DSPS
  @INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS
  @EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS
  @MOBILE_DEFAULT_DSPS
  @INTERNAL_MOBILE_DEFAULT_DSPS
  $ADINSIDE_CLIENT_ID
  $ADINSIDE_USER_ID
  $ADV_VERTIS_USER_ID
  @MAIL_RU_LOGINS

  $SYSTEM_CRON_USER_ID
  $DRIVE2_USER_ID
  $GOMAILRU_ADS_USER_ID
  $M_RU_2015_USER_ID
  $M_RU_TEXT_USER_ID
  $RAMBLER_P_USER_ID
  $TUTBYSEARCH_USER_ID
  $VK_RSYA_APPS_USER_ID
  $VK_RSYA_USER_ID
  $WWWODNOKLASSNIKI_2015_USER_ID
  $WWWODNOKLASSNIKI_USER_ID
  $YNDX_PARTNER_INTAPI_USER_ID
  $SEARCHAUTORU_USER_ID

  $TECHNICAL_RTB_BLOCK_ID
  @BK_LANGUAGES_BY_DEFAULT
  $VIDEO_PLATFORM_FLASH
  $VIDEO_PLATFORM_HTML5
  $VIDEO_PLATFORM_MOBILE
  $VIDEO_PLATFORM_SMART_TV
  $VIDEO_PLATFORMS
  $BLOCK_TYPE_LIMITS
  $CATEGORY_COUNTER
  $CATEGORY_CALCULATED
  $CATEGORY_CASH
  $CATEGORY_PAGE_FIELDS
  $CATEGORY_CALCULATED_WITH_MONEY
  $CATEGORY_RECOMMENDATIONS

  $MOL_REPORT_TYPE_MAIN
  $MOL_REPORT_TYPE_DSP
  $MOL_REPORT_TYPE_MM
  $MOL_STAT_TYPES
  %MOL_STAT_TYPES

  $CATEGORY_MOL_BASIC
  $CATEGORY_MOL_ANALYTIC
  $CATEGORY_MOL_FINANCIAL
  $CATEGORY_MOL_ADDITIONAL
  $CATEGORY_MOL_RECOMMENDATIONS
  $CATEGORY_MOL_DSP

  $CATEGORY_MOL_APPLICATION
  $CATEGORY_MOL_ADV_PLACE
  $CATEGORY_MOL_MONITEZATION

  $CATEGORY_NAMES
  $CATEGORY_TRAFFIC
  $CATEGORY_MONETIZER
  $CATEGORY_ADFOX
  $CATEGORY_BLOCK
  $CATEGORY_DESIGN
  $CATEGORY_PAGE
  $CATEGORY_PARTNER
  $CATEGORY_PRODUCT
  $CATEGORY_B_RULE
  $DISK_STORAGE_DIRECTORY_PATH
  $STATISTICS_PAGE_VS_TAGS_THRESHOLD
  $STATISTICS_PAGE_VS_TAGS_THRESHOLD_OF_VISIBILITY
  $STAT_MONEY_SCALE
  $STAT_MONEY_ADFOX_RTD_COEFF
  $CH_MONEY_POST_SCALE
  $CH_MONEY_PRE_SCALE
  $STREAMING_API_BUFFER_SIZE
  $LOGS_DIRECTORY_PATH
  $VAT_COEFFICIENT
  $EARTH_REGION_ID
  $BALANCE_VIPTYPE_YANDEX

  $DATE_OF_FREEZING_RTB_STAT
  $BOOKMAKER_FLAG_ID
  $MYSQL_DEFAULT_DATETIME
  $MYSQL_MIN_DATE
  $MYSQL_MIN_DATETIME
  $MYSQL_MAX_DATE
  $MYSQL_MAX_DATETIME
  $MYSQL_CHUNK
  $CLICKHOUSE_CHUNK
  $CLICKHOUSE_STATISTICS_PK
  $RUB_CURRENCY_ID
  $DAYS_BEFORE_DELETE_TMP_TABLES
  $CONFIG_FILE_NAME
  $CONFIG_FILE_PATH
  $DB_CONFIG_FILE_PATH
  $SWAGGER_PATH
  $HORIZONTAL_LIMITS
  $BK_MONEY_KOEF
  $PARTNER_FORM_S3_PREFIX
  $FIAS_UPDATE_DATABASES
  $ADBLOCK_PARTNER_ROLE_ID
  $BUSINESS_UNIT_ROLE_ID
  $DEVELOPER_ROLE_ID
  $DSP_MANAGER_ROLE_ID
  $DSP_PARTNER_ROLE_ID
  $DSP_VIEWER_ROLE_ID
  $INDOOR_PARTNER_ROLE_ID
  $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID
  $INTERNAL_YAN_MANAGER_ROLE_ID
  $INTERNAL_YAN_VIEWER_ROLE_ID
  $PROTECTED_PAGES_EDITOR_ROLE_ID
  $DISTRIBUTION_MANAGER_ROLE_ID
  $MOBILE_PARTNER_ROLE_ID
  $SITE_PARTNER_ROLE_ID
  $TUTBY_ROLE_ID
  $VIDEO_PARTNER_ROLE_ID
  $YAN_MANAGER_ROLE_ID
  $YAN_MODERATOR_ROLE_ID
  $YAN_PARTNER_ASSISTANT_ROLE_ID
  $YAN_VIEWER_ROLE_ID
  $ROBOT_ASSISTANT_ROLE_ID
  $ADFOX_ROLE_ID
  $OUTDOOR_PARTNER_ROLE_ID
  $ASSESSOR_ROLE_ID
  $GROUP_DEV
  $GROUP_YNDX_SERVICES
  $GROUP_DSP
  $GROUP_YAN
  $GROUP_SSP
  $GROUP_TUTBY
  $GROUP_ROBOTS
  $INTERNAL_DSP_TAGS
  $BLOCKED_CPM_VALUE
  $MAIL_NOTIFICATION_TYPES
  $SIMPLE_NOTIFICATION_TYPES
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  $DSP_TYPE_MEDIA
  $STICK_TO_VALID_VALUES
  $RSYA_MONETIZER_ID
  $CONTENT_SOURCE_MAX_ID
  $SERVICE_NAME_IN_MODERATION
  $CONTEXT_TARGET_TYPE
  $SEARCH_TARGET_TYPE
  $BIG_SEARCH_TARGET_TYPE
  $PREROLL
  $POSTROLL
  $MIDROLL
  $MIDROLL_MIN_START_TIME
  $INTERSTITIAL
  $INROLL
  $S2SROLL
  $OVERLAY
  $INROLL_OVERLAY
  $OVERLAY_TYPES
  $PAUSE
  $INPAGE
  $VIDEO_BLOCK_TYPES
  $FONT_SIZES
  $BLIND_VALUES
  $SITE_VERSIONS
  $SITE_VERSIONS_TURBO
  @YAN_MIRRORS_LIST
  $COMMON_OFFER_STATISTICS
  $FORMAT_SYSTEM
  $INDOOR_DUMMY_DOMAIN
  $OUTDOOR_DUMMY_DOMAIN
  $MAX_CPM
  $CPM_MULTIPLIER
  %CONTRACT_TYPE
  $FIRM_ID_YANDEX_LTD
  $FIRM_ID_YANDEX_EUROPE_AG
  $FIRM_ID_YANDEX_ADVERTISING
  $BLACKBOX_DBFIELDS
  $RTB_PRODUCT_TYPES
  $VIDEO_PRODUCT_TYPES

  $NOTIFICATION_TYPE
  $NOTIFICATION_VIEW_TYPE
  $NOTIFICATION_ICON
  $NOTIFICATION_FNS
  $NOTIFICATION_CLEANUP_EXCLUDE_LIST
  $TVM_HTTP_HEADER_NAME

  $IDM_SLUG

  @ADFOX_PRESET_ALL
  @ADFOX_PRESET_ASSESSOR
  @ADFOX_PRESET_DEFAULT
  @ADFOX_PRESET_PAIDPRODUCTS

  $INDOOR_FACILITY_TYPE
  $OUTDOOR_FACILITY_TYPE

  $CONTENT_BLOCK_GRID_SIZE
  $NATURAL_BLOCK_GRID_SIZE
  $NATURAL_BLOCK_TRANSPORT_TYPE

  $INTERNAL_PAGE_OWNER_LOGIN

  $LIMIT_CAMPAIGN_FOR_ADDING

  $DESIGN_TYPES
  $DEFAULT_DESIGN_TYPE
  $DEFAULT_VIDEO_SKIN

  $NOTIFICATION_FIELD_LIMIT

  $SELFEMPLOYED_STATUS_NOT
  $SELFEMPLOYED_STATUS_AVAILABLE
  $SELFEMPLOYED_STATUS_READY
  @SELFEMPLOYED_STATUSES

  @AVAILABLE_COOPERATION_FORMS
  $SELFEMPLOYED_COOPERATION_FORM

  %UNIQUE_ID_PREFIX

  $XLS_LIMIT
  $XLSX_LIMIT

  %MODERATION_REASON_TIMEOUTS
  $STAT_AVAILABLE_CURRENCIES

  $DEFAULT_CPM_CURRENCY
  $CPM_AVAILABLE_CURRENCIES
  $IS_PRECISE
  $BOOL_OBJECT

  $BLOCK_TYPE_INTERSTITIAL
  $BLOCK_TYPE_BANNER
  $BLOCK_TYPE_NATIVE
  $BLOCK_TYPE_REWARDED
  $BLOCK_TYPE_ADAPTIVE_BANNER

  $GAME_OFFER_SERVICE
  $GAME_OFFER_MANAGER

  $DO_ACTION_USE_QUEUE_KEY
  $USE_JAVA_JSONAPI_KEY
  $USE_COMMON_BLOCKS_TABLE_KEY
  $QUEUE_IS_METHOD_DISABLED_KEY

  $IGNORABLE_MAIL_LISTS_KEY

  $PROTOBUF_JAVA_TRANSPORT_TURN_ON_KEY
  $TRANSPORTS_KVSTORE_KEYS

  $COMMON_BLOCKS_TABLE_NAME
  $TABLE_PAGE_MODELS

  $MAX_PAGE_SIZE

  $VIP_PROTECTED_MAX_PAGE_ID

  $CONTENT_TYPE
  $CONTENT_TYPE_JSON

  $TRANSFER_USER
  $PAYMENT_TYPES

  $BRANCHES_MAP
  $MYSQL_PRODUCTION_USER

  $MONEY_THRESHOLD
  $IGNORE_EMPTY_SIZES_FOR_INTERSTITIAL

  $STRIPE_PLACE_ID
  $PAGE_SLOTS
  $PAGE_SLOT_SEQUENCES
  $PLACES_DESCRIPTION

  $BLOCKS_WITH_BK_DATA_IN_JAVA

  $AUTOASSIGN_FEATURE_KEY

  $ALICE_SKILLS_BUNDLE_ID
  $DAYS_BEFORE_UNSET_GODMODE

  $GOOGLE_PLAY
  $APP_STORE
  );

our %EXPORT_TAGS = (
    HTTP => [
        qw (
          $DEFAULT_HTTP_TIMEOUT
          $DEFAULT_HTTP_ATTEMPTS
          $DEFAULT_HTTP_DELAY
          )
    ],
    ROLES => [
        qw(
          $ADBLOCK_PARTNER_ROLE_ID
          $ADFOX_ROLE_ID
          $BUSINESS_UNIT_ROLE_ID
          $DEVELOPER_ROLE_ID
          $DSP_MANAGER_ROLE_ID
          $DSP_PARTNER_ROLE_ID
          $DSP_VIEWER_ROLE_ID
          $INDOOR_PARTNER_ROLE_ID
          $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID
          $INTERNAL_YAN_MANAGER_ROLE_ID
          $INTERNAL_YAN_VIEWER_ROLE_ID
          $MOBILE_PARTNER_ROLE_ID
          $OUTDOOR_PARTNER_ROLE_ID
          $ROBOT_ASSISTANT_ROLE_ID
          $SITE_PARTNER_ROLE_ID
          $TUTBY_ROLE_ID
          $VIDEO_PARTNER_ROLE_ID
          $YAN_MANAGER_ROLE_ID
          $YAN_MODERATOR_ROLE_ID
          $YAN_PARTNER_ASSISTANT_ROLE_ID
          $YAN_VIEWER_ROLE_ID
          $ADFOX_ROLE_ID
          $ASSESSOR_ROLE_ID
          $PROTECTED_PAGES_EDITOR_ROLE_ID
          $DISTRIBUTION_MANAGER_ROLE_ID
          )
    ],
    ROLES_GROUPS => [
        qw(
          $GROUP_DEV
          $GROUP_DSP
          $GROUP_ROBOTS
          $GROUP_SSP
          $GROUP_TUTBY
          $GROUP_YAN
          $GROUP_YNDX_SERVICES
          )
    ],
    EMAILS => [
        qw(
          $PARTNERS_MAIL
          $PARTNERS_TEST_MAIL
          $PARTNER2_CRON_MAIL
          $PARTNERS_INTERNAL_ACCESS_REQUESTS_MAIL
          $SUPPORT_MAIL
          $INTERNATIONAL_SUPPORT_MAIL
          $NOTIFICATIONS_MAIL
          $NOTIFICATIONS_YAS_MAIL
          $PARTNER_MANAGERS_MAIL
          $DSP_MAIL
          $DOCS_MAIL
          $DOCS_UA_MAIL
          $START_STOP_MAIL
          $STOP_MOBILE_MAIL
          $MODERATION_MAIL
          $DEVNULL_MAIL
          $GROUP_LEADER_TO_WORK_WITH_INTERNAL_SERVICES
          $SENIOR_MANAGER_FOR_DOCUMENT_PROCESSING_MAIL
          $DEPARTMENT_HEAD_PI_MAIL
          $DEV_GROUP_HEAD_PI_MAIL
          $RESPONSIBLE_TEST_ENGINEER_PI_MAIL
          $TUTBY_COP_MAIL
          $MANAGERS_MAILING_LIST_FOR_FOCUS_DOMAINS
          $PARTNER_DSP_MONITORING_MAIL
          )
    ],
    VIDEO => [
        qw(
          $VIDEO_PLATFORM_FLASH
          $VIDEO_PLATFORM_HTML5
          $VIDEO_PLATFORM_MOBILE
          $VIDEO_PLATFORM_SMART_TV
          $VIDEO_PLATFORMS
          )
    ],
    CURRENCY => [
        qw(
          $RUB_CURRENCY_ID
          )
    ],
    STAFF => [
        qw(
          $DEPARTMENT_HEAD_PI
          $DEV_GROUP_HEAD_PI
          $RESPONSIBLE_TEST_ENGINEER_PI
          )
    ],
    PAGE_SLOT => [
        qw(
          $STRIPE_PLACE_ID
          $PAGE_SLOTS
          $PAGE_SLOT_SEQUENCES
          $PLACES_DESCRIPTION
          )
    ],
);

our $STATISTICS_PAGE_VS_TAGS_THRESHOLD               = 0;
our $STATISTICS_PAGE_VS_TAGS_THRESHOLD_OF_VISIBILITY = 0.01;
our $STAT_MONEY_SCALE                                = 10_000_000_000;
our $STAT_MONEY_ADFOX_RTD_COEFF                      = 10_000;
our $CH_MONEY_PRE_SCALE                              = 1000;
our $CH_MONEY_POST_SCALE                             = 10_000_000;
our $STICK_TO_VALID_VALUES                           = [qw( auto top bottom )];

our $DEVELOPER_ROLE_ID                  = 2;
our $INTERNAL_YAN_MANAGER_ROLE_ID       = 3;
our $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID = 4;
our $DSP_PARTNER_ROLE_ID                = 7;
our $DSP_MANAGER_ROLE_ID                = 8;
our $SITE_PARTNER_ROLE_ID               = 9;
our $YAN_MANAGER_ROLE_ID                = 15;
our $YAN_MODERATOR_ROLE_ID              = 16;
our $YAN_VIEWER_ROLE_ID                 = 17;
our $DSP_VIEWER_ROLE_ID                 = 18;
our $INTERNAL_YAN_VIEWER_ROLE_ID        = 19;
our $VIDEO_PARTNER_ROLE_ID              = 20;
our $MOBILE_PARTNER_ROLE_ID             = 27;
our $BUSINESS_UNIT_ROLE_ID              = 33;
our $ADBLOCK_PARTNER_ROLE_ID            = 36;
our $YAN_PARTNER_ASSISTANT_ROLE_ID      = 37;
our $TUTBY_ROLE_ID                      = 39;
our $INDOOR_PARTNER_ROLE_ID             = 40;
our $ADFOX_ROLE_ID                      = 41;
our $OUTDOOR_PARTNER_ROLE_ID            = 42;
our $ROBOT_ASSISTANT_ROLE_ID            = 43;
our $ASSESSOR_ROLE_ID                   = 44;
our $PROTECTED_PAGES_EDITOR_ROLE_ID     = 45;
our $DISTRIBUTION_MANAGER_ROLE_ID       = 46;

our $GROUP_DEV           = 0;
our $GROUP_YNDX_SERVICES = 1;
our $GROUP_DSP           = 2;
our $GROUP_YAN           = 3;
our $GROUP_SSP           = 8;
our $GROUP_TUTBY         = 9;
our $GROUP_ROBOTS        = 10;

our $DIRECT_PLACE_ID       = 542;
our $DIRECT_PLACE_ID_E     = 1542;
our $STAT_STRIPE_PLACE_IDS = {956 => 1, 1127 => 1, 1194 => 1, 1195 => 1};

our $STAT_MARKET_API_PLACE_ID = 2070;
our $STAT_MARKET_PLACE_ID     = 2020;
our $STAT_PREMIUM_PLACE_ID    = 2010;
our $STAT_MCB_PLACE_IDS       = {662 => 1, 755 => 1, 377 => 1};

our $AGGR_TUTBY = {
    user_id              => '88415289',
    client_id            => '1226565',
    login                => 'tutby-cop',
    title                => 'TUT.BY',
    fake_partner         => undef,
    regional_aggr        => 1,
    regional_aggr_hasdoc => 0,
};

our $BLOCK_TYPE_LIMITS = {
    horizontal => {
        min_height => 125,
        max_height => 500,
    },
    motion => {
        min_height => 170,
        max_height => 2000,
    },
    extensibleMobile => {
        min_height => 170,
        max_height => 2000,
    },
    adaptive => {
        min_width      => 160,
        max_width_coef => 728,

        min_height      => 90,
        max_height_coef => 600,

        min_square      => 60000,
        max_square_coef => 150000,
    }
};

our $HORIZONTAL_LIMITS = $BLOCK_TYPE_LIMITS->{horizontal};

our $DEPARTMENT_HEAD_PI           = 'valerie-il';
our $DEV_GROUP_HEAD_PI            = 'zurom';
our $RESPONSIBLE_TEST_ENGINEER_PI = 'nikolaysy';

our $PAGE_KEYS_TRANSFORM = {
    adblock_blocks    => 'AdblockBlocks',
    application_id    => 'AppID',
    banner_language   => 'BannerLang',
    banners_count     => 'PPCTotal',
    business_unit     => 'BusinessUnit',
    client_id         => 'PartnerID',
    cookie_match_tag  => 'CookieMatchTag',
    cpa               => 'CPA',
    create_date       => 'CreateDate',
    description       => 'Description',
    direct_blocks     => 'DirectBlocks',
    disabled_flags    => 'DisabledFlags',
    domain            => 'Domain',
    dsp_info          => 'DSPInfo',
    excluded_domains  => 'excludeddomains',
    fast_context      => 'FastContext',
    is_graysite       => 'IsGraySite',
    is_in_testmode    => 'IsTesting',
    is_pi2            => 'isPi2',
    is_yandex_page    => 'IsYandexPage',
    login             => 'Login',
    mirrors           => 'Mirrors',
    mobile_app        => 'MobileApp',
    mobile_app_mode   => 'MobileAppMode',
    name              => 'Name',
    only_picture      => 'OnlyPicture',
    options           => 'Options',
    OrderTags         => 'OrderTags',
    page_caption      => 'PageCaption',
    page_id           => 'PageID',
    page_language     => 'Lang',
    page_options      => 'PageOptions',
    pictures_enabled  => 'PicturesEnabled',
    places            => 'Places',
    product_id        => 'ProductID',
    product_type      => 'ProductType',
    rtb_blocks        => 'RtbBlocks',
    rtb_video         => 'RtbVideo',
    sad               => 'sad',
    ssp_seller_id     => 'SSPID',
    ssp_source_tokens => 'SSPPageToken',
    state             => 'State',
    store             => 'Store',
    target_categories => 'TargetCategory',
    target_type       => 'TargetType',
    TargetTags        => 'TargetTags',
    update_time       => 'PIEditTime',
};

our $PARTNERS_MAIL                               = 'support@partner.yandex.ru';
our $PARTNERS_TEST_MAIL                          = 'partners-test-letters@yandex-team.ru';
our $PARTNER2_CRON_MAIL                          = 'partner2-cron@yandex-team.ru';
our $PARTNERS_INTERNAL_ACCESS_REQUESTS_MAIL      = 'partner2-dostup@yandex-team.ru';
our $SUPPORT_MAIL                                = 'support@partner.yandex.ru';
our $INTERNATIONAL_SUPPORT_MAIL                  = 'partner@support.yandex.com';
our $NOTIFICATIONS_MAIL                          = 'notifications@partner.yandex.ru';
our $NOTIFICATIONS_YAS_MAIL                      = 'notification-yas@yandex-team.ru';
our $PARTNER_MANAGERS_MAIL                       = 'partner-managers@yandex-team.ru';
our $DSP_MAIL                                    = 'dsp@yandex-team.ru';
our $DOCS_MAIL                                   = 'docs@partner.yandex.ru';
our $DOCS_PROJECT_MAIL                           = 'docs-project@yandex-team.ru';
our $DOCS_UA_MAIL                                = 'docsUA@yandex-team.ru';
our $START_STOP_MAIL                             = 'start-stop-pi@yandex-team.ru';
our $STOP_MOBILE_MAIL                            = 'autostopmobileapp@yandex-team.ru';
our $MODERATION_MAIL                             = 'moderation-pi@yandex-team.ru';
our $GROUP_LEADER_TO_WORK_WITH_INTERNAL_SERVICES = 'danilushkina@yandex-team.ru';
our $SENIOR_MANAGER_FOR_DOCUMENT_PROCESSING_MAIL = 'pasechnik@yandex-team.com.ua';
our $DEPARTMENT_HEAD_PI_MAIL                     = $DEPARTMENT_HEAD_PI . '@yandex-team.ru';
our $DEVNULL_MAIL                                = 'devnull@yandex-team.ru';
our $TUTBY_COP_MAIL                              = 'cop@tutby.com';
our $COMMON_OFFER_DOCS                           = 'docs-project@yandex-team.ru';
our $CONTRACT_OFFER_ERROR_MAIL                   = 'contract_offer_error@yandex-team.ru';
our $PARTNER2_COMMON_OFFER_ERRORS                = 'partner2-common-offer-errors@yandex-team.ru';
our $MANAGERS_MAILING_LIST_FOR_FOCUS_DOMAINS = 'login_tier_%d@yandex-team.ru';             # template, use with sprintf
our $PARTNER_DSP_MONITORING_MAIL             = 'partner2-dsp-monitoring@yandex-team.ru';
our $PARTNER2_IDM_MAIL                       = 'partner2-idm@yandex-team.ru';

our $DSP_MEDIA_TYPE_ID  = 0;
our $DSP_VIDEO_TYPE_ID  = 1;
our $DSP_MOBILE_TYPE_ID = 2;
our $DSP_NATIVE_TYPE_ID = 3;    #pseudo type, flag for DSP_NATIVE_FORMAT_ID

# temporarily remove blacklist. see PI-29527
our @DSP_MODE = qw(force auto whitelist);    #  extra blacklist

our $DSP_BANNER_FORMAT_ID = 1;
our $DSP_NATIVE_FORMAT_ID = 2;
our $DSP_VIDEO_FORMAT_ID  = 3;

our $DSP_FORMAT_TO_TYPE_MAP = {
    $DSP_BANNER_FORMAT_ID => $DSP_MEDIA_TYPE_ID,
    $DSP_NATIVE_FORMAT_ID => $DSP_NATIVE_TYPE_ID,
    $DSP_VIDEO_FORMAT_ID  => $DSP_VIDEO_TYPE_ID,
};

our $DSP_DIRECT_ID                = 1;
our $DSP_AWAPS_ID                 = 2;
our $DSP_OWN_ADV_ID               = 5;
our $DSP_UNSOLD_ID                = 10;
our $DSP_AWAPS_MOBILE_ID          = 2563084;
our $DSP_CRITEO_NATIVE            = 2563330;
our $VIDEO_INTERSTITIAL_MOBILE_ID = 2563154;
our @VIDEO_INTERSTITIAL_DSPS      = ();                   # https://st.yandex-team.ru/PI-29653#62d668865c0f06630fb1e75e
our @VIDEO_AWAPS_DSPS             = (2563180, 2563201);
our @VIDEO_BANNER_DSPS            = ();                   # https://st.yandex-team.ru/PI-29653#62d668865c0f06630fb1e75e
our @VIDEO_DEFAULT_DSPS                              = ($DSP_DIRECT_ID, 2563117, 2563070);
our @INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = (                                     # PI-19125
    2563117,
    2563070,
);
our @EXTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS = (                                     # PI-19125
    @INTERNAL_CONTEXT_ON_SITE_RTB_DEFAULT_VIDEO_DSPS,
    2563219,
    2563167,
    2563178,
    2563185,
    2563190,
    2563254,
    2563269,
    2563281,
    2563130,
);
our @MOBILE_DEFAULT_DSPS = ($DSP_DIRECT_ID, $DSP_AWAPS_MOBILE_ID, 2563106, 2563150, 2563169, 2563197, 2563200);
our @INTERNAL_MOBILE_DEFAULT_DSPS = ($DSP_DIRECT_ID, $DSP_AWAPS_MOBILE_ID);
our $INTERNAL_DSP_TAGS = [qw(yabs awaps local dc_dsp_test)];

our @BK_LANGUAGES_BY_DEFAULT = qw(by en kz ru uk);

our $ADINSIDE_CLIENT_ID        = 944028;
our $ADINSIDE_USER_ID          = 54519301;
our $INTERNAL_PAGE_OWNER_LOGIN = 'adinside';

our @MAIL_RU_LOGINS = qw(
  gomailru-ads
  m-ru-text
  );

our $SYSTEM_CRON_USER_ID           = 0;
our $DRIVE2_USER_ID                = 305718039;
our $GOMAILRU_ADS_USER_ID          = 217912896;
our $M_RU_2015_USER_ID             = 301137679;
our $M_RU_TEXT_USER_ID             = 28166288;
our $RAMBLER_P_USER_ID             = 120143188;
our $TUTBYSEARCH_USER_ID           = 453982110;
our $VK_RSYA_APPS_USER_ID          = 363072506;
our $VK_RSYA_USER_ID               = 265217053;
our $WWWODNOKLASSNIKI_2015_USER_ID = 301147605;
our $WWWODNOKLASSNIKI_USER_ID      = 34027711;
our $YNDX_PARTNER_INTAPI_USER_ID   = 337625302;
our $ADV_VERTIS_USER_ID            = 356502796;

# перенесли в рамках PI-15355, происхождение не известно
our $SEARCHAUTORU_USER_ID = 32944287;

our $TECHNICAL_RTB_BLOCK_ID = 100_500;

our $VIDEO_PLATFORM_FLASH    = 0;
our $VIDEO_PLATFORM_HTML5    = 1;
our $VIDEO_PLATFORM_MOBILE   = 2;
our $VIDEO_PLATFORM_SMART_TV = 3;
our $VIDEO_PLATFORMS         = {
    $VIDEO_PLATFORM_FLASH    => {label => d_gettext('Flash'),       type => 'flash',},
    $VIDEO_PLATFORM_HTML5    => {label => d_gettext('HTML5'),       type => 'html5',},
    $VIDEO_PLATFORM_MOBILE   => {label => d_gettext('Mobile APPS'), type => 'mobile_apps',},
    $VIDEO_PLATFORM_SMART_TV => {label => d_gettext('Smart TV'),    type => 'smart_tv',},
};

our $CATEGORY_COUNTER               = 1;
our $CATEGORY_CALCULATED            = 2;
our $CATEGORY_CASH                  = 3;
our $CATEGORY_PAGE_FIELDS           = 4;
our $CATEGORY_CALCULATED_WITH_MONEY = 5;
our $CATEGORY_RECOMMENDATIONS       = 6;

our $MOL_REPORT_TYPE_MAIN = 'main';
our $MOL_REPORT_TYPE_DSP  = 'dsp';
our $MOL_REPORT_TYPE_MM   = 'mm';
our $MOL_STAT_TYPES       = [$MOL_REPORT_TYPE_MAIN, $MOL_REPORT_TYPE_DSP, $MOL_REPORT_TYPE_MM];
our %MOL_STAT_TYPES       = (
    $MOL_REPORT_TYPE_MAIN => {label => d_gettext('mol_report_type_main'),},
    $MOL_REPORT_TYPE_DSP  => {label => d_gettext('mol_report_type_dsp'),},
    $MOL_REPORT_TYPE_MM   => {label => d_gettext('mol_report_type_mm'),},
);

our $CATEGORY_MOL_BASIC           = 7;
our $CATEGORY_MOL_ANALYTIC        = 8;
our $CATEGORY_MOL_FINANCIAL       = 9;
our $CATEGORY_MOL_ADDITIONAL      = 10;
our $CATEGORY_MOL_RECOMMENDATIONS = 11;
our $CATEGORY_MOL_DSP             = 12;

our $CATEGORY_PARTNER   = 13;
our $CATEGORY_PRODUCT   = 14;
our $CATEGORY_PAGE      = 15;
our $CATEGORY_BLOCK     = 16;
our $CATEGORY_DESIGN    = 17;
our $CATEGORY_ADFOX     = 18;
our $CATEGORY_MONETIZER = 19;
our $CATEGORY_TRAFFIC   = 20;
our $CATEGORY_B_RULE    = 21;

our $CATEGORY_MOL_APPLICATION  = 22;
our $CATEGORY_MOL_ADV_PLACE    = 23;
our $CATEGORY_MOL_MONITEZATION = 24;

our $CATEGORY_REPORT_GENERAL = 25;
our $CATEGORY_REPORT_PAGE    = 26;
our $CATEGORY_REPORT_BLOCK   = 27;
our $CATEGORY_REPORT_EXTRA   = 28;

# такая конструкция используется для того что бы константы оставались числами, а не становились строками
our $CATEGORY_NAMES = {
    (0 + $CATEGORY_COUNTER)    => d_gettext('Initial data'),           # Исходные данные
    (0 + $CATEGORY_CALCULATED) => d_gettext('Analytical indicators'),  # Аналитические показатели
    (0 + $CATEGORY_CASH)       => d_gettext('Money'),                  # Деньги
    (0 + $CATEGORY_PAGE_FIELDS) => d_gettext('Source data for the entire site'),
    # Исходные данные для всей площадки
    (0 + $CATEGORY_CALCULATED_WITH_MONEY) => d_gettext('Financial indicators'),  # Денежные показатели
    (0 + $CATEGORY_RECOMMENDATIONS) => d_gettext('Recommendations Metrics'),
    # Показатели по рекомендациям
    (0 + $CATEGORY_MOL_BASIC)           => d_gettext('Basic'),
    (0 + $CATEGORY_MOL_ANALYTIC)        => d_gettext('Analytic'),
    (0 + $CATEGORY_MOL_FINANCIAL)       => d_gettext('Financial (net of VAT)'),
    (0 + $CATEGORY_MOL_ADDITIONAL)      => d_gettext('Additional'),
    (0 + $CATEGORY_MOL_RECOMMENDATIONS) => d_gettext('Recommendations'),
    (0 + $CATEGORY_MOL_DSP)             => d_gettext('For DSP'),
    (0 + $CATEGORY_TRAFFIC)             => d_gettext('Traffic'),
    (0 + $CATEGORY_MONETIZER)           => d_gettext('DSP'),
    (0 + $CATEGORY_ADFOX)               => d_gettext('Adfox'),
    (0 + $CATEGORY_BLOCK)               => d_gettext('category_Block'),
    (0 + $CATEGORY_DESIGN)              => d_gettext('Design'),
    (0 + $CATEGORY_PAGE)                => d_gettext('App or site'),
    (0 + $CATEGORY_PARTNER)             => d_gettext('Partner'),
    (0 + $CATEGORY_PRODUCT)             => d_gettext('Product'),
    (0 + $CATEGORY_B_RULE)              => d_gettext('Business rule'),
    (0 + $CATEGORY_MOL_APPLICATION)     => d_gettext('Application'),
    (0 + $CATEGORY_MOL_ADV_PLACE)       => d_gettext('Adv place'),
    (0 + $CATEGORY_MOL_MONITEZATION)    => d_gettext('Financial'),
    (0 + $CATEGORY_REPORT_GENERAL)      => d_gettext('General reports'),
    (0 + $CATEGORY_REPORT_PAGE)         => d_gettext('Page reports'),
    (0 + $CATEGORY_REPORT_BLOCK)        => d_gettext('Block reports'),
    (0 + $CATEGORY_REPORT_EXTRA)        => d_gettext('Extra reports'),
};

our $DISK_STORAGE_DIRECTORY_PATH = '/var/lib/partner2';

our $LOGS_DIRECTORY_PATH = '/var/log';

our $STREAMING_API_BUFFER_SIZE = 10000;

our $VAT_COEFFICIENT = 1.20;

our $EARTH_REGION_ID = 10_000;

our $BALANCE_VIPTYPE_YANDEX = 2;

our $OWNERS_USER_FIELDS = [
    qw(
      id
      login
      client_id
      business_unit
      name
      midname
      lastname
      roles
      is_tutby
      email
      is_assessor
      features
      current_currency
      )
];

our $AUTHORIZATION_USER_FIELDS = [
    qw(
      id
      login
      lastname
      name
      midname
      email
      multistate
      client_id
      phone
      newsletter
      business_unit
      is_mobile_mediation
      has_rsya
      has_mobile_mediation
      common_offer
      is_assessor
      )
];

our $GOOGLE_PLAY = 1;
our $APP_STORE   = 2;

our $APP_TYPES = {
    $GOOGLE_PLAY => {
        id      => 1,
        caption => d_gettext('Android'),
        store   => 'GooglePlay',
    },
    $APP_STORE => {
        id      => 2,
        caption => d_gettext('iOS'),
        store   => 'AppStore',
    }
};
our ($OS_ID_ANDROID, $OS_ID_IOS, $OS_ID_WIN, $OS_ID_OTHER) = (1, 2, 3, 0);

our $DATE_OF_FREEZING_RTB_STAT = '2017-10-01';

our $BOOKMAKER_FLAG_ID = 21;

our $MYSQL_DEFAULT_DATETIME   = '1970-01-01 03:00:00';
our $MYSQL_MIN_DATE           = '1000-01-01';
our $MYSQL_MIN_DATETIME       = '1000-01-01 00:00:00';
our $MYSQL_MAX_DATETIME       = '9999-12-31 23:59:59';
our $MYSQL_MAX_DATE           = '9999-12-31';
our $MYSQL_CHUNK              = 1000;
our $CLICKHOUSE_CHUNK         = 10_000;
our $CLICKHOUSE_STATISTICS_PK = [
    qw(
      dt
      product_id
      page_id
      block_id
      dsp_id
      currency_id
      tag_id
      category_id
      monetizer_id
      geo_id
      )
];

our $RUB_CURRENCY_ID = 2;

our $DAYS_BEFORE_DELETE_TMP_TABLES = 2;

our $CONFIG_FILE_NAME = 'Application.json';
our $CONFIG_FILE_PATH = lib::abs::path("./$CONFIG_FILE_NAME");

our $DB_CONFIG_FILE_PATH = lib::abs::path('./DatabaseConfig.json');

our $SWAGGER_PATH = lib::abs::path('../resources/swagger/swagger.json');

our $BK_MONEY_KOEF = 1_000_000;

our $PARTNER_FORM_S3_PREFIX = 'partner_form';

our $FIAS_UPDATE_DATABASES = [qw(partner_db)];

our $BLOCKED_CPM_VALUE = -1;

our $MAIL_NOTIFICATION_TYPES = {
    BASE                       => 0,
    BLOCK_DOMAIN               => 1,
    BLOCK_PAGE                 => 2,
    BLOCK_LOGIN                => 3,
    APPROVE_PAGE               => 4,
    MONEY                      => 5,
    COMMON_OFFER_STATISTICS    => 6,
    ADFOX_PAID_OFFER_REQUEST   => 7,
    DELETE_PAGE                => 8,
    STOP_PAGE                  => 9,
    EMAIL_DOCS_ABOUT_ORDERS    => 10,
    QUEUE_TASK                 => 11,
    SENDER_BASE                => 12,
    MOBILE_MEDIATION_FIRST_APP => 13,
    APPROVED                   => 14,
    FIRST_APPROVED             => 15,
    REJECTED_BY_MODERATION     => 16,
    ACCESS_GRANTED             => 17,
    NEW_PARTNER_SITE           => 18,
    NEW_PARTNER_MOBILE_APP     => 19,
    NEW_PARTNER_SITE_AND_APP   => 20,
    FIRST_APPROVED_SITE        => 21,
    FIRST_APPROVED_MOBILE_APP  => 22,
    APPROVED_SITE              => 23,
    APPROVED_MOBILE_APP        => 24,
    REJECTED_SITE              => 25,
    REJECTED_MOBILE_APP        => 26,
};

our $SIMPLE_NOTIFICATION_TYPES = ['default', 'survey', 'common_offer', 'custom_link', 'action_banner'];
our $NOTIFICATION_TYPE         = [qw(custom auto)];
our $NOTIFICATION_VIEW_TYPE    = [qw(default common_offer custom_link survey top)];
our $NOTIFICATION_ICON         = [
    qw(
      default
      strategy
      add_block
      new_format
      block_settings_1
      block_settings_2
      block_settings_3
      block_settings_4
      fns
      )
];
our $NOTIFICATION_FNS                  = 'fns_message';
our $NOTIFICATION_CLEANUP_EXCLUDE_LIST = [$NOTIFICATION_FNS];

our $MIN_CPM_STRATEGY_ID      = 0;
our $MAX_REVENUE_STRATEGY_ID  = 1;
our $SEPARATE_CPM_STRATEGY_ID = 3;

our $DSP_TYPE_MEDIA = 1;    #2**0 media

our $RSYA_MONETIZER_ID     = 0;
our $CONTENT_SOURCE_MAX_ID = 999999999;

our $SERVICE_NAME_IN_MODERATION = 'pi';

our $BIG_SEARCH_TARGET_TYPE = 0;
our $CONTEXT_TARGET_TYPE    = 3;
our $SEARCH_TARGET_TYPE     = 2;

our $PREROLL        = 0;
our $POSTROLL       = 1;
our $MIDROLL        = 2;
our $INTERSTITIAL   = 3;
our $PAUSE          = 4;
our $INPAGE         = 5;
our $INROLL         = 6;
our $S2SROLL        = 7;
our $OVERLAY        = 8;
our $INROLL_OVERLAY = 9;

our $OVERLAY_TYPES = {map {$_ => TRUE} ($OVERLAY, $INROLL_OVERLAY)};

our $MIDROLL_MIN_START_TIME = 10;

our $VIDEO_BLOCK_TYPES = {
    $PREROLL => {
        bk         => 'preroll',
        label      => d_gettext('Pre'),
        label_stat => d_gettext('stat_block_type_preroll'),
    },
    $POSTROLL => {
        bk         => 'postroll',
        label      => d_gettext('Post'),
        label_stat => d_gettext('stat_block_type_postroll'),
    },
    $MIDROLL => {
        bk         => 'midroll',
        label      => d_gettext('Mid'),
        label_stat => d_gettext('stat_block_type_midroll'),
    },
    $PAUSE => {
        bk         => 'pauseroll',
        label      => d_gettext('Pause'),
        label_stat => d_gettext('stat_block_type_pauseroll'),
    },
    $INPAGE => {
        bk         => 'inpage',
        label      => d_gettext('Inpage'),
        label_stat => d_gettext('stat_block_type_inpage'),
    },
    $INTERSTITIAL => {
        bk         => 'interstitial',
        label      => d_gettext('Interstitial'),
        label_stat => d_gettext('stat_block_type_video_interstitial'),
    },
    $INROLL => {
        bk         => 'inroll',
        label      => d_gettext('Inroll'),
        label_stat => d_gettext('stat_block_type_inroll'),
    },
    $S2SROLL => {
        bk         => 's2sroll',
        label      => d_gettext('S2sroll'),
        label_stat => d_gettext('stat_block_type_s2sroll'),
    },
    $OVERLAY => {
        bk         => 'overlay',
        label      => d_gettext('Overlay'),
        label_stat => d_gettext('stat_block_type_overlay'),
    },
    $INROLL_OVERLAY => {
        bk         => 'inroll-overlay',
        label      => d_gettext('Inroll-overlay'),
        label_stat => d_gettext('stat_block_type_inrolloverlay'),
    },
};

our $FONT_SIZES = [qw(0.8 0.9 1 1.1 1.2)];

our $BLIND_VALUES = [qw(0 1 2 3)];

our $SITE_VERSIONS = {
    'desktop' =>
      {label => d_pgettext('Site verison', 'Desktop'), label_stat => d_pgettext('Site verison stat', 'Desktop')},
    'mobile' => {label => d_gettext('Mobile'), label_stat => d_pgettext('Site verison stat', 'Mobile')},
    'turbo'  => {
        label           => d_gettext('Turbo-pages'),
        page_imp_option => 'turbo',
    },
    'turbo_desktop' => {
        label           => d_gettext('Turbo-pages desktop'),
        page_imp_option => 'turbo-desktop',
    },
    'amp' => {
        label           => d_gettext('AMP-pages'),
        page_imp_option => 'amp',
    },
    'general' =>
      {label => d_gettext('Desktop or mobile'), label_stat => d_pgettext('Site verison stat', 'Desktop or mobile')},
    'mobile_fullscreen' => {
        label           => d_gettext('Mobile fullscreen'),
        label_stat      => d_pgettext('Site verison stat', 'Mobile fullscreen'),
        page_imp_option => 'fullscreen',
    },
    'mobile_rewarded' => {
        label           => d_gettext('Mobile rewarded'),
        label_stat      => d_pgettext('Site verison stat', 'Mobile rewarded'),
        page_imp_option => 'rewarded',
    },
    'mobile_floorad' =>
      {label => d_gettext('Mobile floor_add'), label_stat => d_pgettext('Site verison stat', 'Mobile floor_add')},
};

our $SITE_VERSIONS_TURBO = {
    turbo         => TRUE,
    turbo_desktop => TRUE
};

our @YAN_MIRRORS_LIST = (
    qw(yastatic.net yandex-team.ru),
    map {'yandex.' . $_} qw(az by com ee fr kg kz lt lv md ru tj tm ua uz co.il com.am com.ge com.tr)
);

our $COMMON_OFFER_STATISTICS = [
    qw(common_offer_trans_new_adfox
      common_offer_trans_link_with_adfox
      common_offer_trans_all
      common_offer_reg_new_adfox
      common_offer_reg_link_with_adfox
      common_offer_reg
      users_reg)
];

our $FORMAT_SYSTEM = {
    'formats' => {
        '240x400'           => TRUE,
        'media'             => TRUE,
        'newPosterVertical' => TRUE,
        'newVertical'       => TRUE,
        'oldPosterVertical' => TRUE,
        'oldVertical'       => TRUE,
        'pictureSearch'     => TRUE,
        'vertical0318'      => TRUE,
        'zen'               => TRUE
    },
    'site_versions' => {
        'turbo_desktop'     => 'turbo-desktop',
        'mobile_fullscreen' => 'mobile-fullscreen',
        'mobile_rewarded'   => 'mobile-rewarded',
        'mobile_floorad'    => 'mobile-floorad',
    },
};

our $INDOOR_DUMMY_DOMAIN  = 'indoor.ya';
our $OUTDOOR_DUMMY_DOMAIN = 'outdoor.ya';

our $MAX_CPM        = 9999;
our $CPM_MULTIPLIER = 1000;

our $CONTENT_BLOCK_GRID_SIZE      = 10;
our $NATURAL_BLOCK_GRID_SIZE      = 10;
our $NATURAL_BLOCK_TRANSPORT_TYPE = 3;

our %CONTRACT_TYPE = (
    UR          => 1,     # С Юр. лицом
    AGGREGATOR  => 2,     # С Агрегатором
    PH          => 3,     # С Физ. лицом
    NONRESIDENT => 4,     # С нерезидентом
    UNIVERSAL   => 5,     # универсальный
    YAN_2014    => 6,     # РСЯ 2014
    NEW_OFFER   => 7,     # Новая оферта РСЯ
    SSP         => 8,     # SSP
    OFFER       => 9,     # Единая оферта
    LICENSE     => 10,    # Лицензионный договор
);

our $FIRM_ID_YANDEX_LTD         = 1;
our $FIRM_ID_YANDEX_EUROPE_AG   = 7;
our $FIRM_ID_YANDEX_ADVERTISING = 27;
our @ADFOX_PRESET_ASSESSOR      = qw(ASSESSOR);
our @ADFOX_PRESET_DEFAULT       = qw(ADFOXSITES MOBILEMEDIATION);
our @ADFOX_PRESET_PAIDPRODUCTS  = qw(PAIDPRODUCTS);
our @ADFOX_PRESET_DM_LITE       = qw(DM_LITE);
our @ADFOX_PRESET_ALL =
  (@ADFOX_PRESET_ASSESSOR, @ADFOX_PRESET_DEFAULT, @ADFOX_PRESET_PAIDPRODUCTS, @ADFOX_PRESET_DM_LITE);

our $BLACKBOX_DBFIELDS = [qw(accounts.login.uid account_info.fio.uid subscription.suid.85 userinfo.lang.uid)];

our $DEFAULT_HTTP_TIMEOUT  = 10;
our $DEFAULT_HTTP_ATTEMPTS = 3;
our $DEFAULT_HTTP_DELAY    = 1;

our $TVM_HTTP_HEADER_NAME = 'X-Ya-Service-Ticket';

our $RTB_PRODUCT_TYPES = [qw(MediaImageReach MediaCreativeReach)];

our $VIDEO_PRODUCT_TYPES = [qw(VideoCreativeReach)];

our $IDM_SLUG = "role";

our $INDOOR_FACILITY_TYPE = {
    # Торговые центры и моллы
    1 => {type => RETAIL, code => 'mall', label => d_gettext('Mall')},
    # Офисные центры
    4 => {type => REALTY, code => 'office_center', label => d_gettext('Office Center')},
    # Жилая недвижимость
    5 => {
        type              => REALTY,
        code              => 'residental_real_estate',
        label             => d_gettext('Residental Real Estate'),
        skip_business_oid => TRUE
    },
    # Аэропорты
    6 => {type => TRANSPORT, code => 'airport', label => d_gettext('Airport')},
    # Вокзалы
    7 => {type => TRANSPORT, code => 'station', label => d_gettext('Station')},
    # Такси
    8 => {type => TRANSPORT, code => 'taxi', label => d_gettext('Taxi'), skip_business_oid => TRUE},
    # Метро
    9 => {type => TRANSPORT, code => 'metro', label => d_gettext('Metro'), skip_business_oid => TRUE},
    # Наземный транспорт
    10 => {
        type              => TRANSPORT,
        code              => 'ground_transportation',
        label             => d_gettext('Ground transportation'),
        skip_business_oid => TRUE
    },
    # АЗС
    11 => {type => RETAIL, code => 'filling_station', label => d_gettext('Motorway filling station')},
    # Аптеки
    12 => {type => RETAIL, code => 'pharmacy', label => d_gettext('Pharmacy')},
    # Развлечения (кинотеатры, клубы и пр.)
    13 => {type => RETAIL, code => 'entertainment', label => d_gettext('Entertainment (movies, clubs, etc)')},
    # Супермаркеты, гипермаркеты
    14 => {type => RETAIL, code => 'supermarket', label => d_gettext('Supermarket, hypermarkets')},
    # Финансовые организации
    15 => {type => RETAIL, code => 'financials', label => d_gettext('Financials')},
    # HoReCa (отели, рестораны, кафе)
    16 => {type => RETAIL, code => 'horeca', label => d_gettext('HoReCa (hotels, restaurants, cafes)')},
    # Салоны красоты
    17 => {type => RETAIL, code => 'beauty_salon', label => d_gettext('Beauty salon')},
    # Фитнес-центры
    18 => {type => RETAIL, code => 'fitness_center', label => d_gettext('Fitness center')},
    # Другое
    19 => {type => RETAIL, code => 'other', label => d_gettext('other')},
};

our $OUTDOOR_FACILITY_TYPE = {
    1 => {
        type        => OUTDOOR_ADVERTISING,
        code        => 'billboards',
        label       => d_gettext('Billboards'),
        resolutions => ['1800x900', '1440x720', '640x320', '720x360', '576x320']
    },
    2 => {
        type        => OUTDOOR_ADVERTISING,
        code        => 'supersites',
        label       => d_gettext('Supersites'),
        resolutions => ['1728x576', '1440x480', '1248x416', '864x288', '1920x600', '940x320', '940x300']
    },
    3 => {type => OUTDOOR_ADVERTISING, code => 'mediafacade', label => d_gettext('Mediafacade'), resolutions => []},
    4 => {
        type        => OUTDOOR_ADVERTISING,
        code        => 'cityboard',
        label       => d_gettext('Cityboard'),
        resolutions => ['1232x900', '770x562']
    },
    5 => {type => OUTDOOR_ADVERTISING, code => 'cityformat', label => d_gettext('Cityformat'), resolutions => []},
};

our $LIMIT_CAMPAIGN_FOR_ADDING = 100;

our $DESIGN_TYPES        = {TGA => 'tga', MEDIA => 'media', NATIVE => 'native', VIDEO => 'video'};
our $DEFAULT_DESIGN_TYPE = 'tga';
our $DEFAULT_VIDEO_SKIN  = 'http://storage.mds.yandex.net/get-partner/14408/default.swf';

our $NOTIFICATION_FIELD_LIMIT = {
    button_caption => {
        custom => 40,
        auto   => 255,
    },
    caption => {
        custom => 200,
        auto   => 255,
    },
    message => {
        custom => 1000,
        auto   => 1000,
    },
    ttl => {
        custom => [1, 30],
        auto   => [0, 99999],
    }
};

our $SELFEMPLOYED_STATUS_NOT       = 0;
our $SELFEMPLOYED_STATUS_AVAILABLE = 1;
our $SELFEMPLOYED_STATUS_READY     = 2;
our @SELFEMPLOYED_STATUSES = ($SELFEMPLOYED_STATUS_NOT, $SELFEMPLOYED_STATUS_AVAILABLE, $SELFEMPLOYED_STATUS_READY,);
our $SELFEMPLOYED_COOPERATION_FORM = 'ph';
our @AVAILABLE_COOPERATION_FORMS   = (
    'byu',        # belarus_ur
    'ph',         # russia_ph
    'sw_yt',      # ag_ur
    'sw_ytph',    # ag_ph belarus_ph ukraine_ph
    'ur',         # russia_ip russia_ur
                  # other
    'sw_ur',
    'ua',
    'yt',
    'ytph',
);

# by db_table_name
our %UNIQUE_ID_PREFIX = (
    'context_on_site_rtb'          => 0,
    'internal_context_on_site_rtb' => 1,
    'mobile_app_rtb'               => 2,
    'context_on_site_content'      => 3,
    'internal_mobile_app_rtb'      => 4,
);

our $XLS_LIMIT  = 65_536 - 10;
our $XLSX_LIMIT = 1_048_576 - 10;

our %MODERATION_REASON_TIMEOUTS = (
    -1      => d_gettext('Remoderation denied'),
    0       => d_gettext('Instant remoderation'),
    86400   => d_gettext('One day'),
    604800  => d_gettext('One week'),
    2592000 => d_gettext('One month'),
);

our $STAT_AVAILABLE_CURRENCIES = ['USD', 'RUB', 'EUR', 'CHF'];

our $DEFAULT_CPM_CURRENCY = 'RUB';
our $CPM_AVAILABLE_CURRENCIES = ['USD', 'RUB', 'EUR'];

our $IS_PRECISE = ($^V lt "v5.15") ? 1 : 0;
our $BOOL_OBJECT = $IS_PRECISE ? 'JSON::XS::Boolean' : 'JSON::PP::Boolean';

our $BLOCK_TYPE_INTERSTITIAL    = 'interstitial';
our $BLOCK_TYPE_BANNER          = 'banner';
our $BLOCK_TYPE_NATIVE          = 'native';
our $BLOCK_TYPE_REWARDED        = 'rewarded';
our $BLOCK_TYPE_ADAPTIVE_BANNER = 'adaptive_banner';

our $GAME_OFFER_SERVICE = 1132;
our $GAME_OFFER_MANAGER = 64751;

our $DO_ACTION_USE_QUEUE_KEY      = 'do_action_use_queue';
our $USE_JAVA_JSONAPI_KEY         = 'use_java_jsonapi';
our $USE_COMMON_BLOCKS_TABLE_KEY  = 'use_common_blocks_table';
our $QUEUE_IS_METHOD_DISABLED_KEY = 'queue_is_method_disabled';

our $IGNORABLE_MAIL_LISTS_KEY = 'ignorable_mail_lists';

our $PROTOBUF_JAVA_TRANSPORT_TURN_ON_KEY = 'java_transport_turn_on_key';
our $TRANSPORTS_KVSTORE_KEYS             = {
    bssoap => {
        always_models     => 'bsooap_transport_always_models',
        never_models      => 'bsooap_transport_never_models',
        always_pages      => 'bsooap_transport_always_pages',
        never_pages       => 'bsooap_transport_never_pages',
        modulo_devisor    => 'bsooap_transport_modulo_divisor',
        modulo_reminders  => 'bsooap_transport_modulo_reminders',
        never_min_page_id => 'bsooap_transport_never_min_page_id',
        probability       => 'bsooap_transport_probability',
    },
    logbroker => {
        always_models     => 'logbroker_transport_always_models',
        never_models      => 'logbroker_transport_never_models',
        always_pages      => 'logbroker_transport_always_pages',
        never_pages       => 'logbroker_transport_never_pages',
        modulo_devisor    => 'logbroker_transport_modulo_divisor',
        modulo_reminders  => 'logbroker_transport_modulo_reminders',
        never_min_page_id => 'logbroker_transport_never_min_page_id',
        probability       => 'logbroker_transport_probability',
    }
};

our $COMMON_BLOCKS_TABLE_NAME = 'context_on_site_rtb';
our $TABLE_PAGE_MODELS        = {
    map {$_ => 1}
      qw(
      internal_context_on_site_campaign
      context_on_site_campaign
      mobile_app_settings
      internal_mobile_app
      )
};

our $MAX_PAGE_SIZE             = 1000;
our $VIP_PROTECTED_MAX_PAGE_ID = 1000;

our $CONTENT_TYPE      = 'application/vnd.api+json';
our $CONTENT_TYPE_JSON = 'application/json';

our $TRANSFER_USER = 'partner_transfer';
our $PAYMENT_TYPES = {
    BANK     => 1,
    YAMONEY  => 2,
    PAYONEER => 7,
};

our $BRANCHES_MAP = {
    ur      => {branch => 'russia_ur',       country_id => 225},
    ph      => {branch => 'russia_ph_part2', country_id => 225},
    sw_ytph => {branch => 'ag_ph',           country_id => undef},
    ua      => {branch => 'ukraine_ph',      country_id => 187},
    sw_yt   => {branch => 'ag_ur',           country_id => undef},
    byu     => {branch => 'belarus_ur',      country_id => 149},
    yt      => {branch => 'ag_ur',           country_id => undef},
};

our $MONEY_THRESHOLD = 2700;

our $MYSQL_PRODUCTION_USER               = 'partner-production';
our $IGNORE_EMPTY_SIZES_FOR_INTERSTITIAL = 1;

# взято из БК as is - https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-pi/Yabs/Transport/PI/Constants.pm?rev=r9169912#L126
our $STRIPE_PLACE_ID = 1127;

# взято из БК as is - https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-pi/Yabs/Transport/PI/Constants.pm?rev=r9169912#L167
# -------------------------------------
# PageSlot по TargetType => Place
# -------------------------------------
our $PAGE_SLOTS = {
    2 => {
        436 => {
            'SlotID'      => 1,
            'Total'       => 3,
            'TypeID'      => 1,
            'Description' => 'Спецразмещение'
        },
        542 => [
            {
                'SlotID'      => 2,
                'Total'       => 7,
                'TypeID'      => 2,
                'Description' => ''
            },
            {
                'SlotID'         => 5,
                'Total'          => 20,
                '_protect_total' => 1,
                'TypeID'         => 1,
                'Description'    => 'Логирование кандидатов для РСЯ в EventDebugLog'
            },
            {
                'SlotID'         => 6,
                'Total'          => 20,
                '_protect_total' => 1,
                'TypeID'         => 2,
                'Description'    => 'Логирование кандидатов для РСЯ в EventDebugLog'
            }
        ],
        659 => {
            'SlotID'      => 3,
            'Total'       => 1,
            'TypeID'      => 3,
            'Description' => ''
        },
        706 => {
            'SlotID'      => 4,
            'Total'       => 0,
            'TypeID'      => 0,
            'Description' => ''
        }
    },
    3 => {
        436 => {
            'SlotID'      => 1,
            'Total'       => 3,
            'TypeID'      => 1,
            'Description' => 'Спецразмещение'
        },
        542 => [
            {
                'SlotID'      => 2,
                'Total'       => 7,
                'TypeID'      => 2,
                'Description' => ''
            },
            {
                'SlotID'         => 7,
                'Total'          => 20,
                '_protect_total' => 1,
                'TypeID'         => 2,
                'Description'    => 'Логирование кандидатов для РСЯ в EventDebugLog'
            }
        ],
        700 => {
            'SlotID'      => 3,
            'Total'       => 1,
            'TypeID'      => 3,
            'Description' => ''
        },
        755 => {
            'SlotID'      => 4,
            'Total'       => 2,
            'TypeID'      => 0,
            'Description' => ''
        },
        848 => {
            'SlotID'      => 5,
            'Total'       => 2,
            'TypeID'      => 0,
            'Description' => ''
        },
        $STRIPE_PLACE_ID => {
            'SlotID'      => 6,
            'Total'       => 1,
            'TypeID'      => 0,
            'Description' => ''
        }
    }
};

# взято из БК as is - https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-pi/Yabs/Transport/PI/Constants.pm?rev=r9169912#L259
# Хэш с инфой о местах
our $PAGE_SLOT_SEQUENCES = {
    2 => {
        'premium' => [
            {
                'SlotID'        => 1,
                'SequenceID'    => 1,
                'PrintSlotID'   => 1,
                'PrintSeqID'    => 1,
                'PlaceID'       => 542,
                'PlaceSelect'   => 5,
                'SequenceLimit' => 3,
                'SequenceCheck' => 3,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'SequenceType'  => 'premium'
            }
        ],
        'direct' => [
            {
                'SlotID'        => 2,
                'SequenceID'    => 1,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 1,
                'PlaceID'       => 542,
                'PlaceSelect'   => 3,
                'SequenceLimit' => 4,
                'SequenceCheck' => 4,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'SequenceType'  => 'guarantee'
            },
            {
                'SlotID'        => 2,
                'SequenceID'    => 2,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 1,
                'PlaceID'       => 542,
                'PlaceSelect'   => 6,
                'SequenceLimit' => 1,
                'SequenceCheck' => 5,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'SequenceType'  => 'dynamic'
            },
            {
                'SlotID'        => 2,
                'SequenceID'    => 3,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 3,
                'PlaceID'       => 632,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 5,
                'ExceptionID'   => 9,
                'OrderType'     => 0
            },
            {
                'SlotID'        => 2,
                'SequenceID'    => 4,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 4,
                'PlaceID'       => 643,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 5,
                'ExceptionID'   => 2,
                'OrderType'     => 0
            },
            {
                'SlotID'                 => 5,
                'SequenceID'             => 1,
                'PrintSlotID'            => 5,
                'PrintSeqID'             => 1,
                'PlaceID'                => 542,
                'PlaceSelect'            => 17,
                'SequenceLimit'          => 20,
                'SequenceCheck'          => 20,
                'ExceptionID'            => 0,
                'OrderType'              => 0,
                'SequenceType'           => 'na',
                "_protect_sequencecheck" => 1
            },
            {
                'SlotID'                 => 6,
                'SequenceID'             => 1,
                'PrintSlotID'            => 6,
                'PrintSeqID'             => 1,
                'PlaceID'                => 542,
                'PlaceSelect'            => 19,
                'SequenceLimit'          => 20,
                'SequenceCheck'          => 20,
                'ExceptionID'            => 0,
                'OrderType'              => 0,
                'SequenceType'           => 'na',
                "_protect_sequencecheck" => 1
            }

        ],
        'market' => [
            {
                'SlotID'        => 3,
                'SequenceID'    => 1,
                'PrintSlotID'   => 3,
                'PrintSeqID'    => 1,
                'PlaceID'       => 659,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 0,
                'OrderType'     => 0
            }
        ],
        'counter' => [
            {
                'SlotID'        => 4,
                'SequenceID'    => 1,
                'PrintSlotID'   => 4,
                'PrintSeqID'    => 1,
                'PlaceID'       => 706,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 0,
                'OrderType'     => 0
            }
        ]
    },
    3 => {
        'premium' => [
            {
                'SlotID'        => 1,
                'SequenceID'    => 1,
                'PrintSlotID'   => 1,
                'PrintSeqID'    => 1,
                'PlaceID'       => 542,
                'PlaceSelect'   => 5,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'SequenceType'  => 'premium'
            }
        ],
        'direct' => [
            {
                'SlotID'        => 2,
                'SequenceID'    => 1,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 1,
                'PlaceID'       => 542,
                'PlaceSelect'   => 3,
                'SequenceLimit' => 4,
                'SequenceCheck' => 4,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'SequenceType'  => 'guarantee'
            },
            {
                'SlotID'        => 2,
                'SequenceID'    => 2,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 2,
                'PlaceID'       => 542,
                'PlaceSelect'   => 6,
                'SequenceLimit' => 1,
                'SequenceCheck' => 5,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'SequenceType'  => 'dynamic'
            },
            {
                'SlotID'        => 2,
                'SequenceID'    => 3,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 4,
                'PlaceID'       => 632,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 5,
                'ExceptionID'   => 9,
                'OrderType'     => 0
            },
            {
                'SlotID'        => 2,
                'SequenceID'    => 4,
                'PrintSlotID'   => 2,
                'PrintSeqID'    => 3,
                'PlaceID'       => 643,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 5,
                'ExceptionID'   => 2,
                'OrderType'     => 0
            },
            {
                'SlotID'                 => 7,
                'SequenceID'             => 1,
                'PrintSlotID'            => 7,
                'PrintSeqID'             => 1,
                'PlaceID'                => 542,
                'PlaceSelect'            => 19,
                'SequenceLimit'          => 20,
                'SequenceCheck'          => 20,
                'ExceptionID'            => 0,
                'OrderType'              => 0,
                'SequenceType'           => 'na',
                "_protect_sequencecheck" => 1
            }

        ],
        'market' => [
            {
                'SlotID'        => 3,
                'SequenceID'    => 1,
                'PrintSlotID'   => 3,
                'PrintSeqID'    => 1,
                'PlaceID'       => 700,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 33,    # block-origin!=0
                'OrderType'     => 0
            },
            {
                'SlotID'        => 3,
                'SequenceID'    => 2,
                'PrintSlotID'   => 3,
                'PrintSeqID'    => 1,
                'PlaceID'       => 943,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 63,    # block-origin=0
                'OrderType'     => 0
            }
        ],
        'media' => [
            {
                'SlotID'        => 4,
                'SequenceID'    => 1,
                'PrintSlotID'   => 4,
                'PrintSeqID'    => 1,
                'PlaceID'       => 755,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 1,
                'SequenceCheck' => 1,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'Size'          => '240x400'
            },
            {
                'SlotID'        => 4,
                'SequenceID'    => 2,
                'PrintSlotID'   => 4,
                'PrintSeqID'    => 1,
                'PlaceID'       => 662,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 1,
                'SequenceCheck' => 1,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
                'Size'          => '200x300'
            },
            {
                'SlotID'        => 4,
                'SequenceID'    => 3,
                'PrintSlotID'   => 4,
                'PrintSeqID'    => 2,
                'PlaceID'       => 796,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 1,
                'ExceptionID'   => 0,
                'OrderType'     => 0
            }
        ],
        'banner-o-market' => [
            {
                'SlotID'        => 5,
                'SequenceID'    => 1,
                'PrintSlotID'   => 5,
                'PrintSeqID'    => 1,
                'PlaceID'       => 854,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
            },
            {
                'SlotID'        => 5,
                'SequenceID'    => 2,
                'PrintSlotID'   => 5,
                'PrintSeqID'    => 1,
                'PlaceID'       => 853,
                'PlaceSelect'   => 11,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 20,
                'OrderType'     => 6,
            }
        ],
        'stripe' => [
            {
                'SlotID'        => 6,
                'SequenceID'    => 1,
                'PrintSlotID'   => 6,
                'PrintSeqID'    => 1,
                'PlaceID'       => $STRIPE_PLACE_ID,
                'PlaceSelect'   => 0,
                'SequenceLimit' => 0,
                'SequenceCheck' => 0,
                'ExceptionID'   => 0,
                'OrderType'     => 0,
            }
        ]
    }
};

# взято из БК as is - https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-pi/Yabs/Transport/PI/Constants.pm?rev=r9169912#L579
our $PLACES_DESCRIPTION = {
    436              => 'premium',
    542              => 'direct',
    659              => 'market',
    700              => 'market',
    706              => 'counter',
    755              => 'media',
    848              => 'banner-o-market',
    $STRIPE_PLACE_ID => 'stripe'
};

our $BLOCKS_WITH_BK_DATA_IN_JAVA = 'blocks_with_bk_data_in_java';
our $DAYS_BEFORE_UNSET_GODMODE   = 60;

our $AUTOASSIGN_FEATURE_KEY = 'autoassign_feature';
our $ALICE_SKILLS_BUNDLE_ID = 'com.yandex.alicekit.demo';

1;
