package PiSecrets;

use strict;
use warnings;

use base qw/ Exporter /;

our @EXPORT = qw(get_secrets get_secret);

use qbit;

our $SECRETS_FILE = '/etc/pi-secrets.json';

=pod

Читает json файл с секретами и возвращает ссылку на хэш
Пример использования:

  PiSecrets->get_secrets()->{juggler}->{token}

=cut

our $secrets;

sub get_secrets {
    unless ($secrets) {
        if (my @env_secret_names = grep {m/^SECRET_/} keys(%ENV)) {
            for my $env_secret_name (@env_secret_names) {
                my ($secret_name) = ($env_secret_name =~ m/^SECRET_(.*)$/);
                $secret_name =~ s/_/-/g;
                $secret_name = lc($secret_name);
                $secrets->{$secret_name} = $ENV{$env_secret_name};
            }
        } else {
            my $json = readfile($SECRETS_FILE);
            $secrets = from_json($json);
        }
    }
    return $secrets;
}

sub get_secret {
    my ($key) = @_;

    my $secrets = get_secrets();
    throw "No key '$key' in the secrets file $SECRETS_FILE" unless exists $secrets->{$key};

    return $secrets->{$key};
}

TRUE;
