
=encoding UTF-8

=head1 Название

Application::Model::API::WebMaster - реализация API вебмастера

=head1 Описание

Базовый класс: L<QBit::Application::Model>

L<Документация|http://wiki.yandex-team.ru/JandeksPoisk/Interfejjsy/CentrVebmastera/dev/internal>

=cut

package QBit::Application::Model;

use qbit;

use base qw(QBit::Application::Part);

sub get_option {
    my ($self, $name, $default) = @_;

    my $opts = $self->app->{'__OPTIONS__'};
    my $res = $opts->{$self->{'accessor'}}{$name} // $opts->{$name} // $default;

    if (defined($res) && (!ref($res) || ref($res) eq 'ARRAY')) {
        foreach my $str (ref($res) eq 'ARRAY' ? @$res : $res) {
            while ($str =~ /^(.*?)(?:\[%\s+([^ ]+)\s+%\])(.*)$/) {
                $str = ($1 || '') . ($self->get_option($2) || '') . ($3 || '');
            }
            while ($str =~ /^(.*?)(?:\$\{\s*([^ ]+)\s*\})(.*)$/) {
                $str = ($1 || '') . ($ENV{$2} || '') . ($3 || '');
            }
        }
    }

    return $res;
}

sub import {
    my ($package, %opts) = @_;

    $package->SUPER::import(%opts);

    throw gettext('Required accessor') unless $opts{'accessor'};

    my $i = 0;
    my $app_pkg;
    while ($app_pkg = caller($i)) {
        last if $app_pkg->isa('QBit::Application');
        $i++;
    }
    throw gettext('Use only in QBit::Application descendant')
      unless $app_pkg->isa('QBit::Application');
}

sub set_option {
    my ($self, $name, $value) = @_;

    $self->app->set_option($self->{'accessor'}, {%{$self->app->get_option($self->{'accessor'}, {})}, $name => $value});
}

sub join_all_coros {
    my ($self, $threads) = @_;

    my $exception;
    my @result;

    foreach (@$threads) {
        my @res = $_->join();

        if (defined(blessed($res[0])) && $res[0]->isa('Exception')) {
            $exception //= $res[0];
        } else {
            push(@result, \@res);
        }
    }

    $self->app->partner_db->close_coroutine_dbhs();

    if ($exception) {
        throw $exception;
    }

    return \@result;
}

TRUE;
