package QBit::Application::Model::API;

use qbit;

use base qw(QBit::Application::Model);

use Exception::API;

my $proc_datetime = undef;

sub _get_cache_file_path {
    my ($self, $method, %params) = @_;

    my $cache_dir = $self->get_option('chi_file_cache_dir');

    my $proc_id = $$;
    unless ($proc_datetime) {
        $proc_datetime //= curdate(oformat => 'db_time');
        $proc_datetime =~ s/:/-/g;
        $proc_datetime =~ s/ /_/;
    }

    if (exists $ENV{DEBUG_STAT_CACHE}) {
        $proc_id       = 100500;
        $proc_datetime = 'YYYY-MM-DD_HH_MM_SS';
    }

    # TODO: smarter sorting. Dates first?
    my $opts_string = join '_', map {$_ . '_' . $params{$_}} sort keys %params;

    (my $method_escaped = $method) =~ s/[\/.]/_/g;

    my $cache_key = join '_', $proc_datetime, $proc_id, $method_escaped, $opts_string;

    return sprintf '%s/%s.dat', $cache_dir, $cache_key;
}

sub _check_cache_file {
    my ($self, $cache_file_path) = @_;

    my $is_cache_ok = FALSE;
    if (-r $cache_file_path && -s $cache_file_path) {
        $is_cache_ok = TRUE;

        if (exists $ENV{DEBUG_STAT_CACHE}) {
            my $file_mtime = (stat($cache_file_path))[9];
            my $ttl_timestamp = get_ttl_timestamp($ENV{DEBUG_STAT_CACHE} || '1day');

            $is_cache_ok = $file_mtime >= $ttl_timestamp ? TRUE : FALSE;
        }
    }

    return $is_cache_ok;
}

TRUE;
