package QBit::Application::Model::API::SOAP;

use qbit;

use base qw(QBit::Application::Model::API);

use SOAP::Lite;
use Data::Rmap;

use Exception::API::SOAP;

sub call {
    my ($self, $func, @opts) = @_;

    $self->{__SOAP__}->{__OPTS__} = \@opts;

    rmap {utf8::decode($_) if defined($_) && !utf8::is_utf8($_) && !Internals::SvREADONLY($_)} \@opts;

    my $result;
    my $error;

  TRY:
    for my $try (1 .. 3) {
        my $som;
        eval {$som = $self->{__SOAP__}->call($func, @opts);};
        $self->{__SOAP__}->{__CUR_SOM__} = $som;
        weaken $som->{_context};

        $error = $@;

        if (!$error) {
            if ($som->fault) {
                $self->log(
                    {
                        proxy_url => $self->{__SOAP__}->proxy->endpoint,
                        uri       => $self->{__SOAP__}->uri,
                        method    => $func,
                        params    => \@opts,
                        error     => $som->faultstring
                    }
                ) if $self->can('log');
                throw Exception::API::SOAP $som->faultstring;
            } else {
                $result = [$som->paramsall];
            }
            last TRY;
        }
        $self->pause();
    }

    $self->log(
        {
            proxy_url => $self->{__SOAP__}->proxy->endpoint,
            uri       => $self->{__SOAP__}->uri,
            method    => $func,
            response  => $result,
            params    => \@opts,
            error     => $error
        }
    ) if $self->can('log');

    throw Exception::API::SOAP $error unless $result;

    return $result;
}

sub init {
    my ($self) = @_;

    local $SOAP::Constants::PATCH_HTTP_KEEPALIVE = 0 if $ENV{TAP_VERSION};

    $self->SUPER::init();

    if ($self->get_option('debug')) {
        eval "use SOAP::Lite '+trace';";
    } else {
        eval "use SOAP::Lite;";
    }

    $self->{'__SOAP__'} =
      SOAP::Lite->new()->proxy($self->get_option('url'), timeout => $self->get_option('http_timeout'))
      ->uri($self->get_option('uri'));

    return TRUE;
}

sub pause() {
    sleep(1);
}

TRUE;
