package QBit::Application::Model::API::XMLRPC;

use qbit;

use base qw(QBit::Application::Model::API);

use Data::Rmap;

use Exception::API::XMLRPC;

sub call {
    my ($self, $func, @opts) = @_;

    rmap {utf8::decode($_) if defined($_) && !utf8::is_utf8($_) && !Internals::SvREADONLY($_)} \@opts;

    my $result;
    my $error;

    for my $try (1 .. 3) {
        my $som;
        eval {$som = $self->{__RPC__}->call($func, @opts);};

        $error = $@;
        if (!$error) {
            if ($som->fault) {
                $self->log(
                    {
                        proxy_url => $self->{__RPC__}->proxy->endpoint,
                        method    => $func,
                        params    => \@opts,
                        error     => $som->faultstring
                    }
                ) if $self->can('log');
                throw Exception::API::XMLRPC $som->faultstring;
            } else {
                $result = [$som->paramsall];
            }

            last;
        }

        sleep(1);
    }

    $self->log(
        {
            proxy_url => $self->{__RPC__}->proxy->endpoint,
            method    => $func,
            params    => \@opts,
            content   => $result,
            error     => $error
        }
    ) if $self->can('log');

    throw Exception::API::XMLRPC $error unless $result;
    return $result;
}

sub init {
    my ($self) = @_;

    local $SOAP::Constants::PATCH_HTTP_KEEPALIVE = 0 if $ENV{TAP_VERSION};

    $self->SUPER::init();

    if ($self->get_option('debug')) {
        eval "use XMLRPC::Lite +trace => 'debug';";
    } else {
        eval "use XMLRPC::Lite;";
    }

    $self->{'__RPC__'} = XMLRPC::Lite->new();
    $self->{'__RPC__'}->proxy($self->get_option('url'), timeout => $self->get_option('http_timeout'));

    return 1;
}

TRUE;
