package QBit::Application::Model::API::Yandex::ConvDB;

use qbit;
use base qw(QBit::Application::Model::API::HTTP);

use Exception::ConvDB;
use Exception::Validation::BadArguments;

sub accessor {'api_conv_db'}

sub get_cpa {
    my ($self, %opts) = @_;

    throw Exception::Validation::BadArguments("Date must have format 'yyyy-mm-dd'")
      if exists($opts{date}) && !check_date($opts{'date'}, iformat => 'db');

    my $result = from_json($self->call('get_cpa', hash_transform(\%opts, [qw(date)])));

    return $result unless ref($result) eq 'HASH';

    $_->{'k'} =~ s/,/./ foreach @{$result->{'pages'}};
    $result->{'k0'} =~ s/,/./;

    return $result;
}

TRUE;
