package QBit::Application::Model::API::Yandex::HTTPGoZora;

=encoding UTF-8

=cut

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

use Exception::API;
use Exception::Zora;
use Exception::Zora::Retry;
use Exception::Zora::Content;
use Exception::Zora::DomainFailed;
use Exception::API::HTTP;
use Utils::Logger qw(INFOF ERROR);

use PiConstants qw($TVM_HTTP_HEADER_NAME);

sub accessor {'api_http_gozora'}

sub get_structure_model_accessors {
    return {
        api_tvm  => 'Application::Model::API::Yandex::TVM',
        kv_store => 'QBit::Application::Model::KvStore',
    };
}

sub request {
    my ($self, %params) = @_;

    $self->{'__LWP__'}->proxy("http", $self->get_option('url'));

    return $self->SUPER::request(%params);
}

sub get_page_inf {
    my ($self, %opts) = @_;

    my ($page_url) = @opts{qw(page_url)};
    throw Exception::Zora 'Must specify page_url' unless $page_url;

    my $tvm_ticket = $self->api_tvm->get_service_ticket($self->get_option('tvm_alias'));
    throw Exception::API gettext('Can not get TVM ticket') unless $tvm_ticket;

    my $headers = {$TVM_HTTP_HEADER_NAME => $tvm_ticket, 'X-Ya-Follow-Redirects' => 'true'};

    my $r = $self->request(
        method        => 'GET',
        uri           => $page_url,
        headers       => $headers,
        attempts      => 1,
        need_response => TRUE
    );

    my $body = $r->decoded_content // $r->content;
    my $eurl = '' . ($r->request->uri);

    my $page_info = {
        body_length_bytes => length($body),
        effective_url     => $eurl,
        status            => $r->code,
        domain            => get_domain($eurl),
    };

    return $page_info;
}

sub is_site_working {
    my ($self, $page_url, %opts) = @_;

    my $domain = get_domain_or_throw($page_url, ascii => TRUE);

    foreach my $secure (TRUE, FALSE) {
        foreach my $www (TRUE, FALSE) {
            if ($self->_try_site_working($domain, $secure, $www, %opts)) {
                return TRUE;
            }
        }
    }

    return FALSE;
}

sub _try_site_working {
    my ($self, $domain, $secure, $www, %opts) = @_;

    if ($www) {
        $domain = 'www.' . $domain;
    }

    my $exist = FALSE;
    my $retry;
    my $retry_cnt = 3;

    my $page_url = ($secure ? 'https://' : 'http://') . $domain;

    do {
        $retry = FALSE;
        try {
            my $page_info = $self->get_page_inf(
                page_url => $page_url,
                timeout  => 30,
                %opts,
            );
            $exist ||= ($page_info->{body_length_bytes} // 0) > 0;
        }
        catch Exception::Zora::DomainFailed with {} catch Exception::Zora::Retry with {
            my ($exception) = @_;

            if ($retry_cnt-- > 0) {
                $retry = TRUE;
            } else {
                $self->app->exception_dumper->dump_as_html_file($exception);
            }
        }
        catch Exception::Zora with {
            my ($exception) = @_;
            $self->app->exception_dumper->dump_as_html_file($exception);
        }
        catch Exception::API::HTTP with {};
    } while ($retry);

    return $exist;
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        $self->get_page_inf(page_url => 'https://ya.ru/');
    }
    catch {
        my ($e) = @_;
        if ($e->message =~ /403 TVM authorization failed/) {
            $result = TRUE;
        }
    };

    return $result;
}

TRUE;
