package QBit::Application::Model::API::Yandex::MoneyMap;

use qbit;
use CHI;

use base qw(QBit::Application::Model::API::HTTP);

use Exception::MoneyMap;
use Exception::Validation::BadArguments;

my $_chi_kv;
my $_chi_key = 'moneymap_cache_key';

sub _get_cached_kv {
    my ($self, $key, $sub, @args) = @_;

    $_chi_kv = CHI->new(driver => 'Memory', global => 1) unless $_chi_kv;
    my $c = $_chi_kv->get($_chi_key) // {};
    my $val = $c->{$key};
    unless ($val) {
        $val = $sub->($self, @args);
        $c->{$key} = $val;
        $_chi_kv->set($_chi_key, $c, '1 hour');
    }

    return $val;
}

sub call {
    my ($self, $method, %opts) = @_;

    $opts{':headers'}{'Content-Type'} = 'application/json';

    my $response;
    try {
        my $r = $self->SUPER::call($method, %opts);
        $response = from_json($r, keep_utf => TRUE);
    }
    catch Exception::API::HTTP with {
        my ($e) = @_;

        if ($e->{response} && $e->{response}->code eq '404') {
            return;
        } elsif ($e->{response} && $e->{response}->code eq '400') {
            my $c = from_json($e->{response}->content, keep_utf => TRUE);
            throw Exception::Validation::BadArguments $c->{message};
        } else {
            throw Exception::MoneyMap $e;
        }
    }
    catch {
        my ($e) = @_;
        throw Exception::MoneyMap $e;
    };

    if ($response && $response->{error}) {
        throw Exception::MoneyMap $response->{message};
    }

    return $response;
}

sub get_internal_owners {
    my ($self) = @_;

    return $self->_get_cached_kv(
        'INTERNAL_OWNERS',
        sub {
            my ($self) = @_;
            $self->call('/api/v1/yt/inner_owners')->{owners} // [];
        }
    );
}

sub fields {
    my ($self) = @_;
    return $self->_get_cached_kv(
        'FIELDS',
        sub {
            my ($self) = @_;
            $self->call('/api/v1/ui/fields');
        }
    );
}

sub get_page {
    my ($self, $page_id, $include_blocks) = @_;

    return $self->call("/api/v1/pages/$page_id" . ($include_blocks ? '?include_blocks=true' : ''));
}

sub pages {
    my ($self, %opts) = @_;

    return $self->call('/api/v1/pages', %opts);
}

sub pages_id {
    my ($self, $page_id, %opts) = @_;

    return $self->call("/api/v1/pages/$page_id", %opts);
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        $self->call("/api/v1/ui/fields");
    }
    catch {
        my ($e) = @_;
        $result = TRUE;
    };

    return $result;
}

sub get_block {
    my ($self, $page_id, $block_id) = @_;

    return $self->call("/api/v1/pages/$page_id/blocks/$block_id");
}

sub blocks {
    my ($self, %opts) = @_;

    return $self->call("/api/v1/blocks", %opts);
}

sub blocks_id {
    my ($self, $page_id, $block_id, %opts) = @_;

    return $self->call("/api/v1/pages/$page_id/blocks/$block_id", %opts);
}

TRUE;
