package QBit::Application::Model::API::Yandex::Passport;

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

use XML::Simple;

use Exception::Validation::BadArguments;

# В конфигурации прописано название секции в конфиге TVM
# В конфиге TVM прописаны идентификаторы приложения для passport
# Распределение идентификаторов расписано тут
# https://wiki.yandex-team.ru/passport/api/?from=%252Fpassport%252Fpython%252Fapi%252F#neobxodimyezagolovki
#     2000078 = prod
#     2000079 = test

sub accessor {'api_passport'}

sub admsubscribe {
    my ($self, %opts) = @_;

    throw Exception::Validation::BadArguments gettext('uid or login must be defined')
      unless defined($opts{'uid'}) || defined($opts{'login'});

    throw Exception::Validation::BadArguments gettext('Missed required parameter from') unless defined($opts{'from'});

    my $data = $self->call(
        'passport',
        mode => 'admsubscribe',
        map {$_ => $opts{$_}} grep {defined($opts{$_})} qw(uid login from unsubscribe)
    );

    return XMLin($data);
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        my $data = $self->call('1/bundle/account/', consumer => 'pi');
    }
    catch {
        my ($e) = @_;
        $result = TRUE if $e->message =~ /tvm_client_id: None/;
    };

    return $result;
}

TRUE;
