package QBit::Application::Model::API::Yandex::Solomon;

=encoding UTF-8

=head1 Название

QBit::Application::Model::API::Yandex::Solomon - API для работы с Solomon

=head1 Описание

Реализут внешний API интерфейс с Solomon.

см https://wiki.yandex-team.ru/solomon/api/dataformat/json/

=end comment

=cut

use qbit;
use base qw(QBit::Application::Model::API::HTTP);

use Exception::Validator::Fields;

__PACKAGE__->model_accessors('validator' => 'Application::Model::Validator');

sub accessor {'api_solomon'}

sub send {
    my ($self, %opts) = @_;

    $self->validator->check(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                ts => {
                    type     => 'int_un',
                    optional => TRUE,
                },
                sensors => {
                    type => 'array',
                    all  => {
                        type   => 'hash',
                        fields => {
                            labels => {
                                type   => 'hash',
                                fields => {sensor => {},},
                                extra  => TRUE,
                            },
                            kind => {
                                optional => TRUE,
                                in       => [qw(DGAUGE IGAUGE COUNTER RATE)],
                            },
                            value => {
                                check => sub {
                                    throw Exception::Validator::Fields gettext('Expected number')
                                      unless looks_like_number($_[1]);
                                  }
                            },
                        },
                        extra => TRUE,
                    },
                    size_min => 1,
                },
            },
            extra => TRUE,
        },
        throw => TRUE,
    );

    $opts{'ts'} //= time;

    #fix types
    $opts{'ts'} += 0;
    map {$_->{'value'} += 0} @{$opts{'sensors'}};

    $self->call(
        '',
        ':post'    => 1,
        ':headers' => {'Content-Type' => 'application/json',},
        ':content' => to_json(\%opts, canonical => TRUE),
    );
}

TRUE;
