package QBit::Application::Model::API::Yandex::Split::Common;

use qbit;

use PiVariables qw(
  FROM_DATE_CLICKHOUSE_BILLING_DATA
  );

use PiConstants qw(
  $STAT_MONEY_SCALE
  );

sub need_balance_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $params{from} ge FROM_DATE_CLICKHOUSE_BILLING_DATA()
      && $params{to} ge FROM_DATE_CLICKHOUSE_BILLING_DATA();
}

sub _make_place_filter_balance_stat_from_clickhouse {
    my ($self, $place) = @_;

    my $filter;
    if (ref $place eq 'ARRAY') {
        $filter = [place_id => 'IN' => \$place];
    } else {
        my @or;
        for my $k (keys %$place) {
            my $p = $place->{$k};
            if ($k =~ /^=(\d+)$/) {
                my $type = $1;
                push @or, [AND => [[type_id => '=' => \$type], [place_id => 'IN' => \$p]]];
            } elsif ($k =~ /^!(\d+)$/) {
                my $type = $1;
                push @or, [AND => [[type_id => '!=' => \$type], [place_id => 'IN' => \$p]]];
            }
        }
        $filter = [OR => \@or];
    }

    return $filter;
}

sub get_balance_stat_from_clickhouse {
    my ($self, %params) = @_;

    my $field_list = delete $params{field_list} or die "call without field_list";

    if (my $model = delete $params{model}) {
        if ($model->can('get_campaign_model_name')) {
            $params{block_model} = $model->accessor;
        } else {
            $params{page_model} = $model->accessor;
        }
    }

    my @filter = ([dt => '>=' => \$params{from}], [dt => '<=' => \$params{to}]);
    if (my $place = $params{only_place}) {
        push @filter, $self->_make_place_filter_balance_stat_from_clickhouse($place);
    }

    my $t = $self->app->clickhouse_db->balance_statistics;

    my $query = $self->app->clickhouse_db->query->select(
        table  => $t,
        fields => $field_list->fields_ch_query,
        filter => [AND => \@filter]
    );

    if (my $model = delete $params{block_model}) {
        $query = $query->join(
            table   => $self->app->clickhouse_db->blocks_dict_table,
            fields  => [],
            filter  => [model => '=' => \$model],
            join_on => [AND => [[page_id => '=' => {page_id => $t}], [id => '=' => {imp_id => $t}]]],
        ) unless $params{only_place};
    } elsif ($model = delete $params{page_model}) {
        $query = $query->join(
            table   => $self->app->clickhouse_db->pages_dict_table,
            fields  => [],
            filter  => [model => '=' => \$model],
            join_on => [page_id => '=' => {page_id => $t}],
        );
    } else {
        die "call without model";
    }

    $query = $query->group_by($field_list->keys_for_ch);

    my %result;
    my $convert_to;
    if ($params{convert_places} && $params{only_place} && ref $params{only_place} eq 'HASH') {
        $convert_to = $params{only_place}->{'!1'};
    }

    for my $row (@{$query->get_all()}) {
        $row->{dt} .= ' 00:00:00';
        if ($convert_to) {
            $row->{place_id} = $convert_to->[0] unless in_array($row->{place_id}, $convert_to);
        }
        my $key = join('-', @{$row}{$field_list->keys_for_ch});
        unless (exists $result{$key}) {
            @{$result{$key}}{$field_list->keys_for_file} = @{$row}{$field_list->keys_for_ch};
        }
        for my $s ($field_list->sum_fields_ch) {
            $result{$key}{$field_list->ch_to_file($s)} += $row->{$s};
        }
    }

    return \%result;
}

sub update_balance_stat_from_clickhouse {
    my ($self, %params) = @_;

    my $field_list = delete $params{field_list} or die "call without field_list";

    my $ch_data = $params{ch_data};
    my $data    = $params{data};

    my %keys;
    for my $row (@$data) {
        my $key = join('-', @{$row}{$field_list->keys_for_file});
        if (my $ch_row = delete $ch_data->{$key}) {
            for my $s ($field_list->sum_fields_file) {
                $row->{$s} = $ch_row->{$s};
            }
        } else {
            @{$row}{$field_list->sum_fields_file} = $field_list->sum_fields_file_zeros;
        }
    }

    return $data;
}

1;
