package QBit::Application::Model::API::Yandex::Split::FieldList;

use qbit;
use PiConstants qw($STAT_MONEY_SCALE);

sub new {
    my ($class, $keys, %map) = @_;

    my @file_key_fields = map  {$map{$_}} @$keys;
    my %is_ch_key       = map  {$_ => TRUE} @$keys;
    my @ch_fields       = grep {$map{$_}} keys %map;
    my @ch_sum_fields   = grep {!$is_ch_key{$_}} @ch_fields;
    my @file_sum_fields = map  {$map{$_}} @ch_sum_fields;
    my %ch_field_query;
    for my $f (@ch_fields) {
        if ($is_ch_key{$f}) {
            $ch_field_query{$f} = '';
        } else {
            $ch_field_query{$f} = {SUM => [['/' => [$f, \$STAT_MONEY_SCALE]]]};
        }
    }

    return bless {
        _keys_for_file => \@file_key_fields,
        _keys_for_ch   => $keys,

        _fields_ch_query => \%ch_field_query,

        _sum_fields_ch   => \@ch_sum_fields,
        _sum_fields_file => \@file_sum_fields,

        _sum_fields_file_zero => [(0) x @file_sum_fields],

        _map => \%map,
    }, $class;
}

sub keys_for_file {
    my ($self) = @_;
    return @{$self->{_keys_for_file}};
}

sub keys_for_ch {
    my ($self) = @_;
    return @{$self->{_keys_for_ch}};
}

sub fields_ch_query {
    my ($self) = @_;
    return $self->{_fields_ch_query};
}

sub sum_fields_ch {
    my ($self) = @_;
    return @{$self->{_sum_fields_ch}};
}

sub sum_fields_file {
    my ($self) = @_;
    return @{$self->{_sum_fields_file}};
}

sub ch_to_file {
    my ($self, $key) = @_;
    return $self->{_map}{$key};
}

sub sum_fields_file_zeros {
    my ($self) = @_;
    return @{$self->{_sum_fields_file_zero}};
}

1;
