package QBit::Application::Model::API::Yandex::Split::GetDspStat;

use qbit;
use base qw(QBit::Application::Model::API::Yandex::Split::Common);

use PiConstants qw(
  $STAT_MONEY_SCALE
  );

my %map_ch_to_file = (
    'dt'             => 'DT',
    'page_id'        => 'PAGE_ID',
    'place_id'       => '',
    'imp_id'         => 'BLOCK_ID',
    'type_id'        => '',
    'dsp_id'         => 'DSP_ID',
    'tag_id'         => '',
    'currency_id'    => '',
    'all_w_nds'      => '',
    'all_wo_nds'     => '',
    'dsp_w_nds'      => 'DSP',
    'dsp_wo_nds'     => 'DSPWITHOUTNDS',
    'partner_w_nds'  => 'PARTNER',
    'partner_wo_nds' => 'PARTNERWITHOUTNDS',
);

my @ch_key_fields = qw(
  dt
  page_id
  imp_id
  dsp_id
  );

my $field_list_hash = {
    0 => QBit::Application::Model::API::Yandex::Split::FieldList->new(\@ch_key_fields, %map_ch_to_file),
    1 => QBit::Application::Model::API::Yandex::Split::FieldList->new(
        [@ch_key_fields, 'tag_id'],
        %map_ch_to_file, 'tag_id' => 'PARTNER_STAT_ID',
    ),
};

my $check_opt = 'include_partner_stat_id';

sub get_dsp_stat {
    my ($self, %params) = @_;

    my $data = $self->get_dsp_stat_orig(%params);

    if (   $params{without_money}
        || $params{_get_tsv_fh}
        || !$self->need_balance_stat_from_clickhouse(%params))
    {
        return $data;
    }

    my $ch_data = $self->get_dsp_stat_from_clickhouse(%params);

    $data = $self->update_dsp_stat_from_clickhouse(%params, data => $data, ch_data => $ch_data);

    return $data;
}

sub get_dsp_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $self->get_balance_stat_from_clickhouse(%params, field_list => $field_list_hash->{$params{$check_opt} // 0});
}

sub update_dsp_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $self->update_balance_stat_from_clickhouse(%params,
        field_list => $field_list_hash->{$params{$check_opt} // 0});
}

1;
