package QBit::Application::Model::API::Yandex::Split::GetInternalPagesTagsStat;

use qbit;
use base qw(QBit::Application::Model::API::Yandex::Split::Common);

use QBit::Application::Model::API::Yandex::Split::FieldList;

my %map_ch_to_file = (
    'dt'             => 'DT',
    'page_id'        => 'PAGE_ID',
    'place_id'       => '',
    'imp_id'         => '',
    'type_id'        => '',
    'dsp_id'         => '',
    'tag_id'         => 'TAG_ID',
    'currency_id'    => '',
    'all_w_nds'      => 'ALL',
    'all_wo_nds'     => 'FULLPARTNERWITHOUTNDS',
    'dsp_w_nds'      => '',
    'dsp_wo_nds'     => '',
    'partner_w_nds'  => '',
    'partner_wo_nds' => '',
);

my @ch_key_fields = qw(
  page_id
  tag_id
  dt
  );

my $field_list = QBit::Application::Model::API::Yandex::Split::FieldList->new(\@ch_key_fields, %map_ch_to_file);

sub get_internal_pages_tags_stat {
    my ($self, %params) = @_;

    my $data = $self->get_internal_pages_tags_stat_orig(%params);

    unless ($self->need_balance_stat_from_clickhouse(%params)) {
        return $data;
    }

    my $ch_data = $self->get_internal_pages_tags_stat_from_clickhouse(%params);

    $data = $self->update_internal_pages_tags_stat_from_clickhouse(%params, data => $data, ch_data => $ch_data);

    return $data;
}

sub get_internal_pages_tags_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $self->get_balance_stat_from_clickhouse(%params, field_list => $field_list);
}

sub update_internal_pages_tags_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $self->update_balance_stat_from_clickhouse(%params, field_list => $field_list);
}

1;
