package QBit::Application::Model::API::Yandex::Split::GetPagesTagsStat;

use qbit;
use base qw(QBit::Application::Model::API::Yandex::Split::Common);

use QBit::Application::Model::API::Yandex::Split::FieldList;

my %map_ch_to_file = (
    'dt'             => 'DT',
    'page_id'        => 'PAGE_ID',
    'place_id'       => 'PLACE_ID',
    'imp_id'         => '',
    'type_id'        => 'TYPE',
    'dsp_id'         => '',
    'tag_id'         => 'TAG_ID',
    'currency_id'    => '',
    'all_w_nds'      => 'ALL',
    'all_wo_nds'     => 'FULLPARTNERWITHOUTNDS',
    'dsp_w_nds'      => '',
    'dsp_wo_nds'     => '',
    'partner_w_nds'  => 'PARTNER',
    'partner_wo_nds' => 'PARTNERWITHOUTNDS',
);

my @ch_key_fields = qw(
  dt
  page_id
  place_id
  tag_id
  type_id
  );

my $field_list = QBit::Application::Model::API::Yandex::Split::FieldList->new(\@ch_key_fields, %map_ch_to_file);

sub get_pages_tags_stat {
    my ($self, %params) = @_;

    my $data = $self->get_pages_tags_stat_orig(%params);

    if ($params{_get_tsv_fh}
        || !$self->need_balance_stat_from_clickhouse(%params))
    {
        return $data;
    }

    my $ch_data = $self->get_pages_tags_stat_from_clickhouse(%params);

    $data = $self->update_pages_tags_stat_from_clickhouse(%params, data => $data, ch_data => $ch_data);

    return $data;
}

sub get_pages_tags_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $self->get_balance_stat_from_clickhouse(%params, field_list => $field_list);
}

sub update_pages_tags_stat_from_clickhouse {
    my ($self, %params) = @_;

    return $self->update_balance_stat_from_clickhouse(%params, field_list => $field_list, add_zero_tags => 1);
}

1;
