
=encoding UTF-8
=cut

=head1 Название

QBit::Application::Model::API::Yandex::StarTrek

=cut

# /usr/share/perl5/Yandex/StarTrek.pm
# https://github.yandex-team.ru/bessarabov/Yandex-StarTrek/

package QBit::Application::Model::API::Yandex::StarTrek;

use qbit;
use PiSecrets;

use base qw(QBit::Application::Model);

use Carp;
use Yandex::StarTrek;
use Time::Local;

sub accessor {'startrek'}

sub create_issue {
    my ($self, $issue_data) = @_;

    return $issue_data->{'queue'} . '-' . int(rand(100500)) if $self->get_option('test');

    my $issue_id = $self->yandex_startrek->create_issue(%$issue_data);

    return $issue_id;
}

sub yandex_startrek {
    my ($self) = @_;

    $self->{__STARTREK__} //= Yandex::StarTrek->new(oauth_token => get_secret('startrek-token'));

    return $self->{__STARTREK__};
}

sub get_issue {
    my ($self, $ticket) = @_;

    return $self->yandex_startrek->get_issue($ticket);
}

sub add_comment {
    my ($self, $ticket, $comment, $summonees, $attachment) = @_;

    return $attachment
      ? $self->_add_comment_with_attachment($ticket, $comment, $summonees, $attachment)
      : $self->yandex_startrek->add_comment($ticket, $comment, $summonees);
}

sub _add_comment_with_attachment {
    my ($self, $issue_key, $comment, $summonees, $attachment) = @_;

    croak 'No issue_key'   if not defined $issue_key;
    croak 'No comment'     if not defined $comment;
    croak 'No attachments' if not defined $attachment;

    my @ids = grep {$_} map {$self->_add_attachment($_, $attachment->{$_})} keys %$attachment;

    my ($json, $status, $response_str) = $self->yandex_startrek->_get_api_response(
        method       => 'POST',
        url          => "/v2/issues/$issue_key/comments",
        content_data => {
            text          => $comment,
            attachmentIds => \@ids,
            $summonees ? (summonees => $summonees) : ()
        },
    );
    croak "Got unexpected status $status. Full content: $response_str" unless $json;

    my ($year, $mon, $mday, $hour, $min, $sec) = split(/[T.:-]+/, $json->{createdAt});
    my $comment_timestamp = timegm($sec, $min, $hour, $mday, $mon - 1, $year);

    return $comment_timestamp . '000' // 0;
}

sub _add_attachment {
    my ($self, $filename, $data) = @_;

    my $response = $self->yandex_startrek->{_lwp}->post(
        $self->yandex_startrek->_get_base_api_host() . "/v2/attachments?filename=$filename.json",
        'Authorization' => 'OAuth ' . $self->yandex_startrek->{_oauth_token},
        'Content-Type'  => 'form-data',
        Content         => [
            attach => [
                undef,
                'attachment.json',
                'Content-Type' => 'application/json',
                Content        => unset_utf(to_json($data, pretty => TRUE)),
            ]
        ]
    );

    my $content = $response->decoded_content // 'No content';

    my $json;
    if ($response->is_success) {
        $json = eval {from_json($content)};
    }

    return $json && $json->{id};
}

sub get_attachment {
    my ($self, $url) = @_;

    # https://st.yandex-team.ru/PI-21115/attachments/23291452?inline=false
    my ($ticket, $id) = $url =~ m|([A-Z]+-\d+)/attachments/(\d+)|;

    croak 'No issue_key'      if not defined $ticket;
    croak 'No attachment_key' if not defined $id;

    # GET /v2/issues/{issue}/attachments/{attachment}/{name}
    my ($json, $status, $response_str) = $self->yandex_startrek->_get_api_response(
        method => 'GET',
        url    => "/v2/issues/$ticket/attachments/$id/file.json",
    );
    croak "Got unexpected status $status. Full content: $response_str" unless $json;

    return $json;
}

TRUE;
