package QBit::Application::Model::API::Yandex::YT::BK;

use qbit;

use base qw(QBit::Application::Model::API::Yandex::YT);

use Exception::API::YT::BK;
use Exception::Validator::Fields;

sub accessor {'api_yt_bk'}

sub export_table {
    my ($self, %opts) = @_;

    $opts{'page_id'} = [$opts{'page_id'}] if defined $opts{'page_id'} && ref($opts{'page_id'}) ne 'ARRAY';
    my $qv = QBit::Validator->new(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                table_name => {
                    in => [
                        qw(
                          Page
                          PageDSP
                          PageImp
                          PageSlot
                          PageSlotSequence
                          PartnerPage
                          BlockSettings
                          DSPTemplate
                          )
                    ]
                },
                page_id => {
                    type     => 'array',
                    optional => TRUE,
                    all      => {type => 'int_un'},
                    check    => sub {
                        my ($qv, $page_id) = @_;

                        throw Exception::Validator::Fields
                          sprintf(q[Field "page_id" hasn't been selected for table "%s"], $qv->data->{'page_id'})
                          if in_array($qv->data->{'table_name'}, [qw(BlockSettings DSPTemplate)])
                              && defined($qv->data->{'table_name'});
                      }
                },
                field_names => {
                    optional => TRUE,
                    type     => 'array',
                    all      => {},
                },
                limit => {type => 'int_un', optional => TRUE},
            },
            deps   => {page_id => 'table_name'},
            any_of => [qw(page_id limit)]
        },
        throw_internal_error => TRUE,
    );

    my $path = "//home/yabs/dict/$opts{'table_name'}";
    my $yql  = '';
    if (exists($opts{'field_names'}) && @{$opts{'field_names'}}) {
        $yql .= join(', ', sort @{$opts{'field_names'}});
    } else {
        $yql .= '*';
    }

    $yql .= " FROM [$path]";

    if (@{$opts{'page_id'}}) {
        $yql .= ' WHERE PageID IN (' . join(', ', @{$opts{page_id}}) . ')';
    }

    if ($opts{'limit'}) {
        $yql .= " LIMIT $opts{'limit'}";
    }

    my $data_jsonl = $self->app->api_yt->select_from_any_replica(
        replicas => $self->app->get_option('yt')->{'replicas'},
        path     => $path,
        yql      => $yql,
        headers  => {'Accept' => 'application/json'},
        params   => {
            input_row_limit => 100_000_000_000,
            ':timeout'      => 20,
            ':attempts'     => 3,
            ':delay'        => 0,
        },
    );

    my $result;
    try {
        $result = from_jsonl($data_jsonl);
    }
    catch {
        throw Exception::API::YT::BK $self->last_response, shift->message;
    };

    return $result;
}

sub get_settings_for_page {
    my ($self, $page_id) = @_;

    my $result = {};

    push_hs($result, %{$self->export_table(table_name => 'PartnerPage', page_id => $page_id)->[0]});

    push_hs($result, %{$self->export_table(table_name => 'Page', page_id => $page_id)->[0]});

    return $result;
}

TRUE;
