package QBit::Application::Model::API::Yandex::YT::Partner::CategoryMapping;

use qbit;

use base qw(QBit::Application::Model::API::Yandex::YT::Partner);

sub accessor {'api_yt_partner_picategory_mapping'}

my $table_path = '/dict/tns_iab_mapping';

my %MEMCACHED_KEY = ('yt_partner' => 'picategory_mapping');
my $CACHE_FOR_SECONDS = 60 * 60;

sub get_structure_model_accessors {
    my ($class) = @_;

    return {memcached => 'QBit::Application::Model::Memcached'};
}

sub get_picategory_articles_mapping {
    my ($self, $opts) = @_;

    my $mapping = $opts->{force} ? undef : $self->memcached->get(%MEMCACHED_KEY);

    unless ($mapping) {
        my $result = $self->select_from_any_replica(
            replicas => $self->app->get_option('yt')->{'replicas'},
            path     => $self->get_prefixed_path($table_path),
            headers  => {'Accept' => 'application/json'},
            yql      => sprintf('id, TNSID, PICategoryID FROM [%s] LIMIT 1000', $self->get_prefixed_path($table_path)),
            params   => {
                ':timeout'       => 60,
                ':attempts'      => 3,
                ':delay'         => 0,
                ':timeout_retry' => 0,
            },
        );

        my $mapping_data = from_jsonl($result);

        foreach (@$mapping_data) {
            push @{$mapping->{TNS_PI}->{$_->{TNSID}}},        $_->{PICategoryID};
            push @{$mapping->{PI_TNS}->{$_->{PICategoryID}}}, $_->{TNSID};
        }

        $self->memcached->set(%MEMCACHED_KEY, $mapping, $CACHE_FOR_SECONDS);
    }

    return $mapping;
}

TRUE;
