package QBit::Application::Model::API::Yandex::YT::Partner::TargetTags;

use qbit;

use base qw(QBit::Application::Model::API::Yandex::YT::Partner);

sub accessor {'api_yt_partner_target_tags'}

my $table_path = {'target_tags' => '/dict/target_tags',};
my %MEMCACHED_KEY = ('yt_partner' => 'target_tags');
my $CACHE_FOR_SECONDS = 60 * 60;

sub get_structure_model_accessors {
    my ($class) = @_;

    return {memcached => 'QBit::Application::Model::Memcached'};
}

=head2

    my $tag_list = $app->api_yt_partner_target_tags->get_target_tags();
=cut

sub get_target_tags {
    my ($self) = @_;

    my $target_tag_list = $self->memcached->get(%MEMCACHED_KEY);

    unless ($target_tag_list) {
        my $tag_list_json_each_row = $self->select_from_any_replica(
            replicas => $self->app->get_option('yt')->{'replicas'},
            path     => $self->get_prefixed_path($table_path->{target_tags}),
            headers  => {'Accept' => 'application/json'},
            yql =>
              sprintf('id, name, descr FROM [%s] LIMIT 1000', $self->get_prefixed_path($table_path->{target_tags})),
            params => {
                ':timeout'       => 60,
                ':attempts'      => 3,
                ':delay'         => 0,
                ':timeout_retry' => 0,
            },
        );

        $target_tag_list = from_jsonl($tag_list_json_each_row);
        $self->memcached->set(%MEMCACHED_KEY, $target_tag_list, $CACHE_FOR_SECONDS);
    }
    return $target_tag_list;
}

TRUE;
