package QBit::Application::Model::DB::clickhouse;

use qbit;

use base qw(QBit::Application::Model::DB);

use QBit::Application::Model::DB::clickhouse::dbi;
use QBit::Application::Model::DB::clickhouse::String;
use QBit::Application::Model::DB::clickhouse::Table;
use QBit::Application::Model::DB::clickhouse::Query;
use QBit::Application::Model::DB::Filter;

use Exception::DB;
eval {require Exception::DB::DuplicateEntry};

BEGIN {
    no strict 'refs';

    foreach my $method (qw(begin commit rollback transaction)) {
        *{__PACKAGE__ . "::$method"} = sub {throw gettext('Method "%s" not supported', $method)}
    }
}

my $REQUEST;

sub query {
    my ($self, %opts) = @_;

    return QBit::Application::Model::DB::clickhouse::Query->new(db => $self, %opts);
}

sub filter {
    my ($self, $filter, %opts) = @_;

    return QBit::Application::Model::DB::Filter->new($filter, %opts, db => $self);
}

sub _create_sql_db {
    my ($self) = @_;

    return 'CREATE DATABASE ' . $self->get_dbh()->quote_identifier($self->get_option('database'));
}

sub _get_table_class {
    my ($self, %opts) = @_;

    my $table_class;
    if (defined($opts{'type'})) {
        my $try_class = "QBit::Application::Model::DB::clickhouse::Table::$opts{'type'}";
        $table_class = $try_class if eval("require $try_class");

        throw gettext('Unknown table class "%s"', $opts{'type'}) unless defined($table_class);
    } else {
        $table_class = 'QBit::Application::Model::DB::clickhouse::Table';
    }

    return $table_class;
}

sub _connect {
    my ($self, %opts) = @_;

    unless (defined($self->get_dbh())) {
        foreach (qw(host port database user password proto ssl_opts)) {
            $opts{$_} //= $self->get_option($_);
        }

        $self->{'__DBH__'}{$self->get_key} = QBit::Application::Model::DB::clickhouse::dbi->new(
            %opts,
            timeout => $self->get_option('timeout', 900),
            db      => $self
        );
    }
}

sub _is_connection_error {
    my ($self, $code) = @_;

    return !!grep {$code // '' eq $_} qw(CH2);
}

sub quote_identifier {"`$_[1]`"}

sub quote {
    my ($self, $value) = @_;

    return 'NULL' unless defined($value);

    if ((blessed($value) // '') eq 'QBit::Application::Model::DB::clickhouse::String') {
        return $value->value;
    } elsif (!looks_like_number($value)) {
        return QBit::Application::Model::DB::clickhouse::String->new($value)->value;
    }

    return $value;
}

TRUE;
