package QBit::Application::Model::DB::clickhouse::Query;

use qbit;

use base qw(QBit::Application::Model::DB::Query);

BEGIN {
    no strict 'refs';

    foreach my $method (qw(for_update left_join right_join)) {
        *{__PACKAGE__ . "::$method"} = sub {throw gettext('Method "%s" not supported', $method)}
    }
}

sub format {$_[0]->{'__FORMAT__'} = $_[1]}

sub _get_format {
    my $format = $_[0]->{'__FORMAT__'};
    return defined $format && $format eq 'NOFormat' ? undef : $format || 'JSONCompact';
}

sub get_all {
    my ($self) = @_;

    local $QBit::Application::Model::DB::clickhouse::st::FORMAT = $self->_get_format() if $self->_get_format();

    return $self->SUPER::get_all();
}

sub get_sql_with_data {
    my ($self, %opts) = @_;

    my ($sql, @params) = $self->SUPER::get_sql_with_data(%opts);

    # Добавляем формат только если он явно выставлен
    # безусловное добавление ломает конструкцию insert ... select
    $sql .= ' FORMAT ' . $self->_get_format() if $self->_get_format();

    return ($sql, @params);
}

sub _found_rows {
    my ($self) = @_;

    return $self->db->get_dbh->{'__FOUND_ROWS__'};
}

sub _field_to_sql {
    my ($self, $alias, $expr, $cur_query_table, %opts) = @_;

    if ((blessed($expr) // '') eq 'QBit::Application::Model::DB::clickhouse::String') {
        return ($self->quote($expr) . (defined($alias) ? ' AS ' . $self->quote_identifier($alias) : ''));
    }

    return $self->SUPER::_field_to_sql($alias, $expr, $cur_query_table, %opts);
}

TRUE;
