package QBit::Application::Model::DB::clickhouse::dbi;

use qbit;

use base qw(QBit::Class);

use LWP::UserAgent;
use HTTP::Request;

use PiSecrets;

use QBit::Application::Model::DB::clickhouse::st;

__PACKAGE__->mk_ro_accessors(qw(db));

__PACKAGE__->mk_accessors(qw(err errstr));

sub init {
    my ($self) = @_;

    weaken($self->{'db'});

    my $uri = URI->new(
        sprintf('%s://%s:%s/',
            $self->{'proto'}                 // 'http',
            $ENV{'CLICKHOUSE_SPECIFIC_HOST'} // $self->{'host'},
            $ENV{'CLICKHOUSE_SPECIFIC_PORT'} // $self->{'port'})
    );

    my $password = $self->{'password'} // get_secret('partner2-clickhouse-password') // '';
    my $user     = $self->{'user'}     // get_secret('partner2-clickhouse-user')     // 'partner';

    $uri->query_form(
        database => $self->{'database'},
        user     => $user,
        password => $password,
        map {my $option_value = $self->db->get_option($_); defined($option_value) ? ($_ => $option_value) : ()}
          qw(
          max_ast_depth
          max_ast_elements
          max_bytes_before_external_group_by
          max_bytes_before_external_sort
          max_memory_usage
          max_query_size
          output_format_json_quote_64bit_integers
          )
    );

    $self->{'__REQUEST__'} = HTTP::Request->new(POST => $uri);

    $self->{'__LWP__'} = LWP::UserAgent->new(
        timeout => $self->{'timeout'},
        ($self->{ssl_opts} ? (ssl_opts => $self->{ssl_opts}) : ()),
    );
}

sub prepare {
    my ($self, $sql) = @_;

    return QBit::Application::Model::DB::clickhouse::st->new(
        request => $self->{'__REQUEST__'},
        lwp     => $self->{'__LWP__'},
        sql     => $sql,
        dbi     => $self
    );
}

sub do {
    my ($self, $sql, $attr, @params) = @_;

    my $sth = $self->prepare($sql);

    my $res = $sth->execute(@params);

    $self->errstr($sth->errstr()) unless $res;

    return $res;
}

TRUE;
