package QBit::Application::Model::DB::mysql::Table::MultistateActionLog;

use qbit;

use base qw(QBit::Application::Model::DB::mysql::Table);

sub default_fields {
    my ($package, %opts) = @_;

    my $opts_type = 'TEXT';
    if ($opts{'with_opts'} and ref($opts{'with_opts'}) eq 'HASH' and exists $opts{'with_opts'}->{'type'}) {
        $opts_type = $opts{'with_opts'}->{'type'};
    }

    return (
        {name => 'id', type => 'BIGINT',   unsigned => TRUE, not_null => TRUE, autoincrement => TRUE},
        {name => 'dt', type => 'DATETIME', not_null => TRUE},
        {name => 'user_id'},
        (
            map {{name => "elem_$_", ($opts{'without_model_foreign_key'} ? (type => 'BIGINT') : ()), not_null => TRUE}}
              @{$opts{'elem_table_pk'}}
        ),
        {name => 'old_multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
        {name => 'action',         type => 'VARCHAR', length   => 100,  not_null => TRUE},
        {name => 'new_multistate', type => 'BIGINT',  unsigned => TRUE, not_null => TRUE},
        ($opts{'with_opts'} ? {name => 'opts', type => $opts_type, not_null => TRUE} : ()),
        {name => 'comment', type => 'VARCHAR', length => 100, not_null => TRUE, default => ''},
    );
}

sub default_foreign_keys {
    my ($package, %opts) = @_;

    return (
        [['user_id'] => users => ['id']],
        (
            $opts{'without_model_foreign_key'}
            ? ()
            : [[map {"elem_$_"} @{$opts{'elem_table_pk'}}] => $opts{'elem_table'} => $opts{'elem_table_pk'}]
        ),
    );
}

sub default_indexes {
    my ($package, %opts) = @_;
    my @elems = $opts{'elem_table_pk'} ? map("elem_$_", @{$opts{'elem_table_pk'}}) : 'elem_id';
    return ({fields => ['dt', @elems, 'action']}, {fields => [@elems, 'action']});
}

sub default_primary_key {
    return ['id'];
}

TRUE;
