package QBit::Application::Model::DB::mysql::Table::RTB;

use qbit;

use base qw(QBit::Application::Model::DB::mysql::Table::RTBWithoutDesignFields);

sub default_fields {
    my ($package, %opts) = @_;

    return (
        $package->SUPER::default_fields(%opts),
        {name => 'direct_block',  type => 'VARCHAR', length   => '32', not_null => TRUE},
        {name => 'limit',         type => 'INT',     unsigned => TRUE},
        {name => 'media_block',   type => 'VARCHAR', length   => '12', not_null => TRUE},
        {name => 'border_radius', type => 'BOOLEAN',},
        {name => 'border_type',          type => 'VARCHAR', length   => '8'},
        {name => 'favicon',              type => 'BOOLEAN', default  => 0},
        {name => 'no_sitelinks',         type => 'BOOLEAN', default  => 0},
        {name => 'links_underline',      type => 'BOOLEAN', default  => 1},
        {name => 'site_bg_color',        type => 'VARCHAR', length   => '6'},
        {name => 'bg_color',             type => 'VARCHAR', length   => '6'},
        {name => 'border_color',         type => 'VARCHAR', length   => '6'},
        {name => 'header_bg_color',      type => 'VARCHAR', length   => '6'},
        {name => 'sitelinks_color',      type => 'VARCHAR', length   => '6'},
        {name => 'title_color',          type => 'VARCHAR', length   => '6'},
        {name => 'text_color',           type => 'VARCHAR', length   => '6'},
        {name => 'url_color',            type => 'VARCHAR', length   => '6'},
        {name => 'url_background_color', type => 'VARCHAR', length   => '6'},
        {name => 'hover_color',          type => 'VARCHAR', length   => '6'},
        {name => 'font_family',          type => 'VARCHAR', length   => '15'},
        {name => 'font_size',            type => 'VARCHAR', length   => '3'},
        {name => 'title_font_size',      type => 'TINYINT', unsigned => TRUE},
        {name => 'adaptive_width',       type => 'VARCHAR', length   => 4, not_null => TRUE, default => ''},
        {name => 'adaptive_height',      type => 'VARCHAR', length   => 4, not_null => TRUE, default => ''},
        {name => 'is_custom_format_direct', type => 'BOOLEAN', not_null => TRUE, default => 0},
        {name => 'callouts',                type => 'BOOLEAN'},
    );
}

sub default_foreign_keys {
    my ($package, %opts) = @_;

    throw 'Expected "page_table" and page_id_name_in_page'
      unless defined($opts{'page_table'}) && defined($opts{'page_id_name_in_page'});

    return (
        [[($opts{'page_id_name_in_rtb'} // 'campaign_id')] => $opts{'page_table'} => [$opts{'page_id_name_in_page'}]]);
}

TRUE;
