package QBit::Application::Model::DB::mysql::Table::RTBWithoutDesignFields;

use qbit;

use base qw(QBit::Application::Model::DB::mysql::Table);

sub default_fields {
    my ($package, %opts) = @_;

    return (
        {name => $opts{'page_id_name_in_rtb'} // 'campaign_id', type => 'INT', unsigned => TRUE, not_null => TRUE,},
        {name => 'id',          type => 'INT', unsigned => 1, not_null => 1},
        {name => 'create_date', type => 'DATETIME'},
        {name => 'caption',    type => 'VARCHAR', length   => '255', not_null => TRUE, default  => ''},
        {name => 'multistate', type => 'BIGINT',  unsigned => TRUE,  not_null => TRUE, default  => 0},
        {name => 'geo',        type => 'MEDIUMTEXT'},
        {name => 'mincpm',     type => 'DECIMAL', length   => 10,    decimals => 3,    unsigned => TRUE,},
        {name => 'comment',    type => 'TEXT'},
        {name => 'is_custom_bk_data', type => 'BOOLEAN', not_null => TRUE, default => 0},
        {name => 'bk_data',           type => 'MEDIUMTEXT',},
        {name => 'media_active',      type => 'BOOLEAN',},
        {name => 'media_blocked',     type => 'BOOLEAN',},
        {name => 'media_cpm',    type => 'DECIMAL', length => 10, decimals => 3, unsigned => TRUE,},
        {name => 'text_active',  type => 'BOOLEAN',},
        {name => 'text_blocked', type => 'BOOLEAN',},
        {name => 'text_cpm',     type => 'DECIMAL', length => 10, decimals => 3, unsigned => TRUE,},
        {name => 'opts', type => 'JSON', not_null => TRUE},
    );
}

sub default_indexes {
    my ($package, %opts) = @_;

    return ({fields => [qw(id)]});
}

sub default_primary_key {
    my ($package, %opts) = @_;

    return [(defined($opts{'page_id_name_in_rtb'}) ? $opts{'page_id_name_in_rtb'} : 'campaign_id'), 'id'];
}

TRUE;
