package QBit::Application::Model::DB::mysql::Table::ShardedTable;

use qbit;

use base qw(QBit::Application::Model::DB::mysql::Table);

use Exception::DB;

sub edit {
    shift->_create_and_do('edit', @_);
}

sub delete {
    shift->_create_and_do('delete', @_);
}

sub add_multi {
    shift->_create_and_do('add_multi', @_);
}

sub name {
    $_[0]->{'shard_name'}->($_[0]->SUPER::name);
}

sub _create_and_do {
    my ($self, $meth, @params) = @_;

    try {
        $self ->${\"SUPER::$meth"}(@params);
    }
    catch Exception::DB with {
        my ($exception) = @_;

        # Exceptions thrown from db->_do() have "errorcode" parameter which is a MySQL server error code.
        # Code 1146 means "Table XXX doesn't exist".
        # In case of this code we need to create the table and try writing again.
        #
        if ($exception->{'errorcode'} && $exception->{'errorcode'} == 1146) {
            $self->db->_do($self->create_sql());
            $self ->${\"SUPER::$meth"}(@params);
        } else {
            throw $exception;
        }
    };
}

TRUE;
