package QBit::Application::Model::DBManager::Filter::alias;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

sub pre_process {
    my ($self, $field, $field_name, %opts) = @_;

    unless (exists($self->{'__REAL_FILTER__'})) {
        my $accessor = $self->{'db_manager'};

        foreach my $filter_name (@{$self->{'path'}}) {
            $self->{'__REAL_FILTER__'} = $accessor->get_db_filter_fields(
                %opts,
                private             => TRUE,
                fields              => [$filter_name],
                without_pre_process => TRUE,
            )->{$filter_name};

            $self->{'__REAL_OBJECT__'} = $accessor->{'__DB_FILTER__'}{$filter_name};

            if ($self->{'__REAL_FILTER__'}{'type'} eq 'subfilter') {
                my $sub_model = $self->{'__REAL_FILTER__'}{'model_accessor'};
                $accessor = $accessor->$sub_model;
            }
        }
    }

    my $filter_field = clone($self->{'__REAL_FILTER__'});

    if ($self->{'__REAL_OBJECT__'}->can('pre_process')) {
        $self->{'__REAL_OBJECT__'}->pre_process($filter_field, $self->{'__REAL_OBJECT__'}->{'field_name'}, %opts);
    }

    foreach (keys(%$filter_field)) {
        next if $_ eq 'db_filter';

        $field->{$_} = $filter_field->{$_};
    }

    delete($field->{'path'});
}

sub public_keys {
    my ($self) = @_;

    return $self->{'__REAL_OBJECT__'}->public_keys;
}

sub check {
    my $self = shift;

    return $self->{'__REAL_OBJECT__'}->check(@_) if $self->{'__REAL_OBJECT__'}->can('check');
}

sub as_filter {
    my ($self, $data, $model_field, %opts) = @_;

    my @fields = reverse(@{$self->{'path'}});
    my $filter = [shift(@fields), $data->[1], $data->[2]];
    foreach my $field (@fields) {
        $filter = [$field => 'MATCH' => $filter];
    }

    my $first_filter_name  = $self->{'path'}[0];
    my $first_model_filter = $self->{'db_manager'}->get_db_filter_fields(
        %opts,
        private => TRUE,
        fields  => [$first_filter_name],
    )->{$first_filter_name};

    return $first_model_filter->{'db_filter'}
      ? $first_model_filter->{'db_filter'}->($self->{'db_manager'}, $filter, $first_model_filter, %opts)
      : $self->{'db_manager'}->{'__DB_FILTER__'}{$first_filter_name}->as_filter($filter, $first_model_filter, %opts);
}

sub expressions {
    my $self = shift;

    return $self->{'__REAL_OBJECT__'}->expressions(@_);
}

TRUE;
