package QBit::Application::Model::DBManager::Filter::boolean;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

use Exception::Validation::BadArguments;

sub as_filter {
    $_[1]->[2]
      ? (defined($_[2]->{'db_expr'}) ? $_[2]->{'db_expr'} : ['AND' => [[$_[1]->[0] => '=' => \1]]])
      : [AND => [defined($_[2]->{'db_expr'}) ? {'NOT' => [$_[2]->{'db_expr'}]} : [$_[1]->[0] => '=' => \0]]];
}

sub as_text {
    $_[1]->[2] ? $_[1]->[0] : 'NOT ' . $_[1]->[0];
}

sub check {
    throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
        $_[1]->[0], $_[0]->type())
      if $_[1]->[1] ne '=';

    throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)', $_[1]->[0],
        $_[0]->type)
      if ref($_[1]->[2]) && ref($_[1]->[2]) !~ /::boolean$/i;
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return ["$uc_field_name { [\$_[1] => '=' => TRUE] }", "NOT $uc_field_name { [\$_[2] => '=' => FALSE] }"];
}

sub need_tokens {return [qw(NOT)]}

TRUE;
