package QBit::Application::Model::DBManager::Filter::contractnumber;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

use Exception::Validation::BadArguments;

sub as_filter {
    my ($self, $filter) = @_;

    my $values = $filter->[2];
    my @contract_numbers = @{ref($values) eq 'ARRAY' ? $values : [$values]};
    my @client_ids =
      map {$_->{'Person'}->{'client_id'}}
      map {@{$_[0]->db_manager->app->api_balance->get_partner_contracts(ExternalID => $_)}} @contract_numbers;
    @client_ids = array_uniq(\@client_ids);

    if (@client_ids == 1) {
        return [client_id => '=' => \$client_ids[0]];
    } elsif (@client_ids) {
        return [client_id => 'IN' => \\@client_ids];
    } else {
        return undef;
    }
}

sub as_text {
    my $string;
    if (ref($_[1]->[2]) eq 'ARRAY') {
        $string = '[' . join(', ', map {s/'/\\'/g; "'$_'"} @{$_[1]->[2]}) . ']';
    } else {
        $string = $_[1]->[2];
        $string =~ s/'/\\'/g;
        $string = "'$string'";
    }
    "$_[1]->[0] $_[1]->[1] $string";
}

sub check {
    if ($_[1]->[1] eq '=') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          unless !ref($_[1]->[2]) || ref($_[1]->[2]) eq 'ARRAY';
    } elsif ($_[1]->[1] eq 'IN') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if ref($_[1]->[2]) ne 'ARRAY';
    } else {
        throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
            $_[1]->[0], $_[0]->type());
    }
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return [
        "$uc_field_name '='      STRING      { [$field_name => '='        => \$_[3]] }",
        "$uc_field_name '='      string_list { [$field_name => '='        => \$_[3]] }",
        "$uc_field_name IN       string_list { [$field_name => 'IN'       => \$_[3]] }",
    ];
}

sub need_tokens {return [qw(STRING IN)]}

sub nonterminals {
    return {
        strings     => "STRING { [\$_[1]] }\n        |   STRING ',' strings { [\$_[1], \@{\$_[3]}] }\n        ;",
        string_list => "'[' strings ']' { \$_[2] }\n        ;"
    };
}

TRUE;
