package QBit::Application::Model::DBManager::Filter::date;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter::text);

use Exception::Validation::BadArguments;

sub as_filter {
    [
        defined($_[2]->{'db_expr'})
        ? $_[2]->{'db_expr'}
        : $_[1]->[0] => $_[1]->[1] => \($_[1]->[2])
    ];
}

sub as_text {
    my $string;

    if (defined($_[1]->[2])) {
        $string = $_[1]->[2];
        $string =~ s/'/\\'/g;
        $string = "'$string'";
    } else {
        $string = 'NULL';
    }

    "$_[1]->[0] $_[1]->[1] $string";
}

sub check {
    throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)', $_[1]->[0],
        $_[0]->type)
      if !defined($_[1]->[2]) || ref($_[1]->[2]);

    throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
        $_[1]->[0], $_[0]->type())
      unless grep {$_[1]->[1] eq $_} qw(= <> > < >= <=);

    throw Exception::Validation::BadArguments gettext('Bad format date for filter by field "%s" (type: %s)', $_[1]->[0],
        $_[0]->type)
      unless check_date($_[1]->[2], iformat => 'db') || check_date($_[1]->[2], iformat => 'db_time');
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return [
        "$uc_field_name '='      STRING      { [$field_name => '='        => \$_[3]] }",
        "$uc_field_name '<>'     STRING      { [$field_name => '<>'       => \$_[3]] }",
        "$uc_field_name '>'      STRING      { [$field_name => '>'        => \$_[3]] }",
        "$uc_field_name '<'      STRING      { [$field_name => '<'        => \$_[3]] }",
        "$uc_field_name '>='     STRING      { [$field_name => '>='       => \$_[3]] }",
        "$uc_field_name '<='     STRING      { [$field_name => '<='       => \$_[3]] }",
    ];
}

sub need_tokens {return [qw(STRING)]}

sub nonterminals {
    return {strings => "STRING { [\$_[1]] }\n        |   STRING ',' strings { [\$_[1], \@{\$_[3]}] }\n        ;",};
}

TRUE;
