package QBit::Application::Model::DBManager::Filter::domain;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter::text);

sub as_filter {
    my ($self, $data, $model_field, %opts) = @_;

    my $domain;
    if ('ARRAY' eq ref $data->[2]) {
        $domain = [map {get_domain($_)} @{$data->[2]}];
    } else {
        $domain = get_domain($data->[2]);
    }

    return [
        $data->[0] => $data->[1] => \(
            $data->[1] =~ /LIKE/
            ? QBit::Application::Model::DBManager::Filter::text::__like_str($domain)
            : $domain
        )
    ];
}

sub expressions { }

TRUE;
