package QBit::Application::Model::DBManager::Filter::domain_mirror;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter::text);

sub check {
    my ($self, $data) = @_;

    my ($field_name, $operation, $value) = @$data;

    my %known = map {$_ => 1} ('=', '<>', 'LIKE', 'NOT LIKE');

    if (!$known{$operation}) {
        throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $operation,
            $field_name, $self->type());
    }
}

sub as_filter {
    my ($self, $data, $field, %opts) = @_;

    my ($field_name, $operation, $value) = @$data;

    my $domain;
    if ('ARRAY' eq ref $value) {
        $domain = [map {get_domain($_)} @{$value}];
    } else {
        $domain = get_domain($value);
    }

    my $base_filter = [domain => $operation => $domain];
    my $filter = [
        ((grep {$operation eq $_} '=', 'LIKE') ? 'OR' : 'AND'),
        [
            $self->{'db_manager'}->_get_db_filter_from_data([domain => MATCH => $base_filter], %opts)->expression(),
            $self->{'db_manager'}->_get_db_filter_from_data(
                [
                    mirror => MATCH => (
                        $self->db_manager->mirrors->get_model_fields->{multistate}
                        ? [AND => [$base_filter, [multistate => '=' => 'not rejected and not deleted'],]]
                        : $base_filter
                    )
                ],
                %opts
              )->expression()
        ]
    ];

    return $filter;
}

TRUE;
