package QBit::Application::Model::DBManager::Filter::json;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

sub as_filter {
    my ($self, $data, $model_field, %opts) = @_;

    my $path = $model_field->{'path'} // sprintf('$.%s', $data->[0]);
    return [
        {json_unquote => [{json_extract => ['opts', \$path]}]} => $data->[1] => \(
            $data->[1] =~ /LIKE/
            ? QBit::Application::Model::DBManager::Filter::text::__like_str($data->[2])
            : $data->[2]
        )
    ];
}

sub expressions { }

TRUE;
