package QBit::Application::Model::DBManager::Filter::json_dict;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter::dictionary);

sub as_filter {
    my ($self, $filter, $model_field, %opts) = @_;

    my $result;
    if (defined($model_field->{'db_expr'})) {
        $result = [$model_field->{'db_expr'}];
    } else {
        my ($field, $operation, $value) = @$filter;
        $value = [$value] unless ref $value;
        my $path = $model_field->{path} // sprintf('$.%s', $field);
        my $db_field = {json_extract => ['opts', \$path]};
        if ($operation eq '=' || $operation eq '<>') {
            $result = [OR => [map {{json_contains => [$db_field, {json_array => [\$_]}]},} @$value]];
        } else {
            $result = [$db_field => $operation => \$value];
        }
        $result = [AND => [{NOT => [$result]}]] if $operation eq '<>' || $operation eq 'NOT IN';
    }

    return $result;
}

TRUE;
