package QBit::Application::Model::DBManager::Filter::login;
{
    $QBit::Application::Model::DBManager::Filter::login::VERSION = '0.001';
}

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter::text);

sub as_filter {
    if (defined($_[2]->{'db_expr'})) {
        return [$_[2]->{'db_expr'}];
    } else {
        my ($login, $operation, $value) = @{$_[1]};

        if ($operation =~ /LIKE$/) {
            return [$login => $operation =>
                  \QBit::Application::Model::DBManager::Filter::text::__like_str(fix_login($value))
            ];
        } elsif ($operation =~ /IN$/ && (ref($value) eq 'ARRAY') && @$value == 1) {
            return [$login => ($operation eq 'IN' ? '=' : '<>') => \fix_login($value->[0])];
        } else {
            return [
                $login => $operation => ref($value) eq 'ARRAY'
                ? \[map {fix_login($_)} @$value]
                : \fix_login($value)
            ];
        }
    }
}

TRUE;
