package QBit::Application::Model::DBManager::Filter::multistate;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

use Exception::Multistate;
use Exception::Validation::BadArguments;

sub as_filter {
    my ($self, $filter) = @_;

    my $values;
    if (ref($filter->[2]) eq 'ARRAY') {
        $values = $filter->[2];
    } else {
        try {
            $values = $self->{'db_manager'}->get_multistates_by_filter($filter->[2]);
        }
        catch Exception::Multistate with {
            throw Exception::Validation::BadArguments $_[0];
        };
    }

    return [$filter->[0] => $filter->[1] => \$values];
}

sub as_text {
    "$_[1]->[0] $_[1]->[1] $_[1]->[2]";
}

sub check {
    throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
        $_[1]->[0], $_[0]->type())
      unless $_[1]->[1] eq '=' || $_[1]->[1] eq '<>';

    throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)', $_[1]->[0],
        $_[0]->type)
      unless defined($_[1]->[2])
          && ((!ref($_[1]->[2]) && $_[1]->[2] =~ /^[()a-zA-Z0-9_\s]+$/) || ref($_[1]->[2]) eq 'ARRAY');
}

sub expressions {
    my ($self, $field_name, $field, %opts) = @_;

    my $uc_field_name = uc($field_name);
    my $ns = lc(join('___', @{$opts{'ns'} || []}));

    return [
        $uc_field_name 
          . " '='  "
          . ($ns ? "${ns}___" : '')
          . "${field_name}___multistate"
          . " { [$_[1] => '='  => \$_[3]] }",
        $uc_field_name 
          . " '<>' "
          . ($ns ? "${ns}___" : '')
          . "${field_name}___multistate"
          . " { [$_[1] => '<>' => \$_[3]] }"
    ];
}

sub nonterminals {
    my ($self, $field_name, $field, %opts) = @_;

    my $ns = lc(join('___', @{$opts{'ns'} || []}));

    return {($ns ? "${ns}___" : '')
          . "${field_name}___multistate" => join(" { \$_[1] }\n        |   ", map {uc($_)} keys(%{$field->{'values'}}))
          . " { \$_[1] }\n        ;"
    };
}

sub pre_process {
    my ($self, $field, $field_name, %opts) = @_;

    throw gettext('Class "%s" must be descedant of "QBit::Application::Model::Multistate"', ref($self->{'db_manager'}))
      unless $self->{'db_manager'}->isa('QBit::Application::Model::Multistate');

    $field->{'values'} = {
        map {$_->[0] => ref($_->[1]) eq 'CODE' ? $_->[1]() : $_->[1]}
        grep {!$_->[2]{'private'}} @{$self->{'db_manager'}->get_multistates_bits()}
    };
}

sub public_keys {return [qw(values)];}

sub tokens {
    my ($self, $field_name, $field) = @_;

    return {
        map {uc($_) => {re => '/\G(\Q' . uc($_) . '\E)/igc and return (' . uc($_) . ' => $1)', priority => length($_)}}
          keys(%{$field->{'values'}})
    };
}

TRUE;
