package QBit::Application::Model::DBManager::Filter::number;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

use Exception::Validation::BadArguments;

sub as_filter {
    [defined($_[2]->{'db_expr'}) ? $_[2]->{'db_expr'} : $_[1]->[0] => $_[1]->[1] => \$_[1]->[2]];
}

sub as_text {
    "$_[1]->[0] $_[1]->[1] "
      . (ref($_[1]->[2]) eq 'ARRAY' ? '[' . join(', ', @{$_[1]->[2]}) . ']' : $_[1]->[2] // 'NULL');
}

sub check {
    if ($_[1]->[1] eq '=' || $_[1]->[1] eq '<>') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          unless !ref($_[1]->[2]) || ref($_[1]->[2]) eq 'ARRAY';
    } elsif ($_[1]->[1] eq 'IN' || $_[1]->[1] eq 'NOT IN') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if ref($_[1]->[2]) ne 'ARRAY';
    } elsif ($_[1]->[1] eq 'IS' || $_[1]->[1] eq 'IS NOT') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if defined($_[1]->[2]);
    } elsif (
        grep {
            $_[1]->[1] eq $_
        } qw(> >= < <=)
      )
    {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if ref($_[1]->[2]);
    } else {
        throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
            $_[1]->[0], $_[0]->type());
    }
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return [
        "$uc_field_name '='    NUMBER      { [$field_name => '='      => \$_[3]] }",
        "$uc_field_name '<>'   NUMBER      { [$field_name => '<>'     => \$_[3]] }",
        "$uc_field_name '>'    NUMBER      { [$field_name => '>'      => \$_[3]] }",
        "$uc_field_name '>='   NUMBER      { [$field_name => '>='     => \$_[3]] }",
        "$uc_field_name '<'    NUMBER      { [$field_name => '<'      => \$_[3]] }",
        "$uc_field_name '<='   NUMBER      { [$field_name => '<='     => \$_[3]] }",
        "$uc_field_name IS     NUMBER      { [$field_name => IS       => \$_[3]] }",
        "$uc_field_name 'IS NOT' NUMBER      { [$field_name => 'IS NOT'   => \$_[3]] }",
        "$uc_field_name '='    number_list { [$field_name => '='      => \$_[3]] }",
        "$uc_field_name '<>'   number_list { [$field_name => '<>'     => \$_[3]] }",
        "$uc_field_name IN     number_list { [$field_name => 'IN'     => \$_[3]] }",
        "$uc_field_name NOT IN number_list { [$field_name => 'NOT IN' => \$_[4]] }"
    ];
}

sub need_tokens {return [qw(NUMBER NOT IN IS)]}

sub nonterminals {
    return {
        numbers     => "NUMBER { [\$_[1]] }\n        |   NUMBER ',' numbers { [\$_[1], \@{\$_[3]}] }\n        ;",
        number_list => "'[' numbers ']' { \$_[2] }\n        ;"
    };
}

TRUE;
