package QBit::Application::Model::DBManager::Filter::period;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter::text);

use Exception::Validation::BadArguments;

sub as_filter {
    my ($period, $period_filter) = $_[0]->get_parsed_period_filter($_[1][2], $_[1][0], 1, 1);

    $period_filter;
}

sub as_text {
    my $string;

    if (defined($_[1]->[2])) {
        $string = $_[1]->[2];
        $string =~ s/'/\\'/g;
        $string = "'$string'";
    } else {
        $string = 'NULL';
    }

    "$_[1]->[0] $_[1]->[1] $string";
}

sub check {
    my ($self, $filter) = @_;

    my ($field, $op, $val) = @$filter;

    throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $op, $field,
        $self->type())
      if $op ne '=';

    # cм. QBit::Date::name2dates
    throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)', $field,
        $self->type)
      if !$val
          || ref($val)
          || !(
                 $val =~ /^\d+days$/
              || $val =~ /^past\d+days$/
              || grep {$val eq $_}
              qw(
              day                today         lasttoday
              dayaftertomorrow   tomorrow
              daybeforeyesterday lastyesterday yesterday

              last7days          lastweek      sevendays    pastweek   week

              tendays

              last30days         lastmonth     pastmonth    thismonth  month

              pastyear           thisyear      twoyearsago  year
              )
          );
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return ["$uc_field_name '='      STRING      { [$field_name => '='        => \$_[3]] }",];
}

# TODO: подобная функция реализована в библиотеке для статистики:
# lib/Application/Model/Statistics/_Utils/Query.pm
# и расширенной статистике:
# https://github.yandex-team.ru/partner/partner2/pull/423/files#diff-5071c9768e4f05ef1eabfbf2d8a9a123
# Нужно свести их в одно место и оттуда использовать
sub get_parsed_period_filter {
    my ($self, $period, $date_field_name, $with_minutes, $with_refs) = @_;

    if ($period && ref($period) ne 'ARRAY' && $period !~ /\d{4}-\d{2}-\d{2}/) {
        $period = [name2dates($period, '', '', iformat => 'db', oformat => 'db')];
    } elsif ($period =~ /\d{4}-\d{2}-\d{2}/) {
        $period = [$period, $period];
    }

    throw Exception::Validation::BadArguments gettext('Invalid period for "%s" (type: %s) in filter', $date_field_name,
        $self->type)
      unless $period
          && ref($period) eq 'ARRAY'
          && check_date($period->[0], iformat => 'db')
          && check_date($period->[1], iformat => 'db')
          && $period->[0] le $period->[1];

    my $date_start = $period->[0];
    my $date_end   = $period->[1];
    $date_end .= ' 23:59:59' if $with_minutes;

    return (
        $period,
        [
            AND => [
                [$date_field_name => '>=' => ($with_refs ? \$date_start : $date_start)],
                [$date_field_name => '<=' => ($with_refs ? \$date_end   : $date_end)]
            ]
        ]
    );
}

sub need_tokens {return [qw(STRING)]}

sub nonterminals {
    return {strings => "STRING { [\$_[1]] }\n        |   STRING ',' strings { [\$_[1], \@{\$_[3]}] }\n        ;",};
}

TRUE;
