package QBit::Application::Model::DBManager::Filter::publicid;
{
    $QBit::Application::Model::DBManager::Filter::publicid::VERSION = '0.001';
}

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

use Exception::Validation::BadArguments;

sub as_filter {
    my ($self, $filter, $model_field) = @_;

    my $values = $filter->[2];
    my $are_values_in_array = ref($values) eq 'ARRAY' ? TRUE : FALSE;

    foreach my $value ($are_values_in_array ? @$values : $values) {
        unless (scalar grep {$value =~ /$_/} keys %{$model_field->{'regexp'}}) {
            return [AND => [\undef]];
        }
    }

    my @filters = ();
    if ($model_field->{'regexp'}) {
        @filters =
          map {$self->_get_filter_for_entry_by_regexp($_, $filter, $model_field)}
          ($are_values_in_array ? @{$values} : $values);
    } else {
        @filters = [$filter->[0] => $filter->[1] => \$values];
    }

    my $operation = $filter->[1];
    if ($operation eq 'NOT IN' || $operation eq '<>') {
        if (@filters == 1) {
            return [AND => [{NOT => [@filters]}]];
        } else {
            return [AND => [{NOT => [[AND => [@filters]]]}]];
        }
    } elsif ($are_values_in_array) {
        return [OR => [@filters]];
    } else {
        return $filters[0];
    }
}

sub as_text {
    "$_[1]->[0] $_[1]->[1] " . (ref($_[1]->[2]) eq 'ARRAY' ? '[' . join(', ', @{$_[1]->[2]}) . ']' : "$_[1]->[2]");
}

sub check {
    if ($_[1]->[1] eq '=' || $_[1]->[1] eq '<>') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          unless !ref($_[1]->[2]) || ref($_[1]->[2]) eq 'ARRAY';
    } elsif ($_[1]->[1] eq 'IN' || $_[1]->[1] eq 'NOT IN') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if ref($_[1]->[2]) ne 'ARRAY';
    } else {
        throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
            $_[1]->[0], $_[0]->type());
    }
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return [
        "$uc_field_name '='    PUBLIC_ID      { [$field_name => '='      => \$_[3]] }",
        "$uc_field_name '<>'   PUBLIC_ID      { [$field_name => '<>'     => \$_[3]] }",
        "$uc_field_name '='    public_id_and_number_list { [$field_name => '='      => \$_[3]] }",
        "$uc_field_name '<>'   public_id_and_number_list { [$field_name => '<>'     => \$_[3]] }",
        "$uc_field_name IN     public_id_and_number_list { [$field_name => 'IN'     => \$_[3]] }",
        "$uc_field_name NOT IN public_id_and_number_list { [$field_name => 'NOT IN' => \$_[4]] }",
        "$uc_field_name '='    NUMBER      { [$field_name => '='      => \$_[3]] }",
        "$uc_field_name '<>'   NUMBER      { [$field_name => '<>'     => \$_[3]] }",
    ];
}

sub need_tokens {return [qw(PUBLIC_ID NUMBER NOT IN)]}

sub nonterminals {
    return {
        public_id_and_numbers => "PUBLIC_ID { [\$_[1]] }\n"
          . "        | NUMBER { [\$_[1]] }\n"
          . "        | PUBLIC_ID ',' public_id_and_numbers { [\$_[1], \@{\$_[3]}] }\n"
          . "        | NUMBER ',' public_id_and_numbers { [\$_[1], \@{\$_[3]}] }\n"
          . "        ;",
        public_id_and_number_list => "'[' public_id_and_numbers ']' { \$_[2] }\n        ;",
    };
}

sub tokens {
    return (
        PUBLIC_ID => {
            re       => '/\G([A-Z]+(?:-[0-9]+)+)/igc and return (PUBLIC_ID => $1)',
            priority => 0
        },
    );
}

sub _get_filter_for_entry_by_regexp {
    my ($self, $entry, $filter, $model_field) = @_;

    my $operation = $filter->[1];
    $operation = 'IN' if $operation eq 'NOT IN';
    $operation = '='  if $operation eq '<>';

    foreach my $regexp (keys %{$model_field->{'regexp'}}) {
        my $db_fields = $model_field->{'regexp'}{$regexp};
        my @db_fields = @$db_fields;

        my @filters = grep {$_->[0]}
          map {[shift(@db_fields) => $operation => ref($filter->[2]) eq 'ARRAY' ? \[$_] : \$_]} ($entry =~ /$regexp/);

        if (@filters) {
            return @filters > 1 ? [AND => \@filters] : $filters[0];
        }
    }

    return undef;
}

TRUE;
