package QBit::Application::Model::DBManager::Filter::text;

use qbit;

use base qw(QBit::Application::Model::DBManager::Filter);

use Exception::Validation::BadArguments;

sub as_filter {
    [
        defined($_[2]->{'db_expr'})
        ? $_[2]->{'db_expr'}
        : $_[1]->[0] => $_[1]->[1] => \($_[1]->[1] =~ /LIKE/ ? __like_str($_[1]->[2]) : $_[1]->[2])
    ];
}

sub as_text {
    my $string;
    if (ref($_[1]->[2]) eq 'ARRAY') {
        $string = '[' . join(', ', map {s/'/\\'/g; "'$_'"} @{$_[1]->[2]}) . ']';
    } elsif (defined($_[1]->[2])) {
        $string = $_[1]->[2];
        $string =~ s/'/\\'/g;
        $string = "'$string'";
    } else {
        $string = 'NULL';
    }
    "$_[1]->[0] $_[1]->[1] $string";
}

sub check {
    if ($_[1]->[1] eq '=' || $_[1]->[1] eq '<>') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          unless !ref($_[1]->[2]) || ref($_[1]->[2]) eq 'ARRAY';
    } elsif ($_[1]->[1] eq 'IN' || $_[1]->[1] eq 'NOT IN') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if ref($_[1]->[2]) ne 'ARRAY';
    } elsif ($_[1]->[1] eq 'LIKE' || $_[1]->[1] eq 'NOT LIKE') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if ref($_[1]->[2]);
    } elsif ($_[1]->[1] eq 'IS' || $_[1]->[1] eq 'IS NOT') {
        throw Exception::Validation::BadArguments gettext('Incorrect data for filter by field "%s" (type: %s)',
            $_[1]->[0], $_[0]->type)
          if defined($_[1]->[2]);
    } else {
        throw Exception::Validation::BadArguments gettext('Bad operator "%s" for "%s" (type: %s) in filter', $_[1]->[1],
            $_[1]->[0], $_[0]->type());
    }
}

sub expressions {
    my ($self, $field_name) = @_;

    my $uc_field_name = uc($field_name);

    return [
        "$uc_field_name '='      STRING      { [$field_name => '='        => \$_[3]] }",
        "$uc_field_name '<>'     STRING      { [$field_name => '<>'       => \$_[3]] }",
        "$uc_field_name LIKE     STRING      { [$field_name => 'LIKE'     => \$_[3]] }",
        "$uc_field_name NOT LIKE STRING      { [$field_name => 'NOT LIKE' => \$_[4]] }",
        "$uc_field_name 'IS'     STRING      { [$field_name => 'IS'       => \$_[3]] }",
        "$uc_field_name 'IS NOT' STRING      { [$field_name => 'IS NOT'   => \$_[3]] }",
        "$uc_field_name '='      string_list { [$field_name => '='        => \$_[3]] }",
        "$uc_field_name '<>'     string_list { [$field_name => '<>'       => \$_[3]] }",
        "$uc_field_name IN       string_list { [$field_name => 'IN'       => \$_[3]] }",
        "$uc_field_name NOT IN   string_list { [$field_name => 'NOT IN'   => \$_[4]] }",
    ];
}

sub need_tokens {return [qw(STRING NOT LIKE IN IS)]}

sub nonterminals {
    return {
        strings     => "STRING { [\$_[1]] }\n        |   STRING ',' strings { [\$_[1], \@{\$_[3]}] }\n        ;",
        string_list => "'[' strings ']' { \$_[2] }\n        ;"
    };
}

sub __like_str {
    my ($text) = @_;

    return $text unless defined($text);

    $text =~ s/%/\\%/g;
    $text =~ s/_/\\_/g;

    $text =~ s/\*/%/g;
    $text =~ s/\?/_/g;

    $text = '%' . $text unless $text =~ s/^\^//;
    $text = $text . '%' unless $text =~ s/([^\\])\$$/$1/;

    $text =~ s/^\Q%\^/%^/;
    $text =~ s/\Q\$%\E$/\$%/;

    return $text;
}

TRUE;
