package QBit::Application::Model::KvStore;

use qbit;

use base qw(QBit::Application::Model);

use Exception::Validation::BadArguments;

sub accessor {'kv_store'}

__PACKAGE__->model_accessors(db => 'QBit::Application::Model::DB::KvStore');

sub delete {
    my ($self, $key) = @_;

    $self->_check($key);

    $self->db->kv_store->delete($key);
}

sub get {
    my ($self, $key, %opts) = @_;

    $self->_check($key);

    my $data = $self->db->kv_store->get($key, %opts);

    return $data->{value};
}

sub get_last_change {
    my ($self, $key, %opts) = @_;

    $self->_check($key);

    my $data = $self->db->kv_store->get($key, %opts);

    return $data->{last_change};
}

sub set {
    my ($self, $key, $value) = @_;

    $self->_check($key);
    $self->_check($value);

    $self->db->kv_store->replace({key => $key, value => $value});
}

sub _check {
    my ($self, $smth) = @_;

    throw Exception::Validation::BadArguments gettext("'%s' should be scalar", $smth) if ref $smth ne '';
    throw Exception::Validation::BadArguments gettext("Element should be defined") if not defined $smth;
    throw Exception::Validation::BadArguments gettext("'%s' should be less than %s symbols", $smth,
        $self->db->get_size_kv_store_value)
      if length($smth) > $self->db->get_size_kv_store_value;
}

TRUE;
