package QBit::Application::Model::Multistate;

use qbit;

use base qw(QBit::Application::Model);

use Exception::Multistate;

# TODO: сделать общий метод
#sub init {
#    my ($self) = @_;
#
#    $self->SUPER::init();
#
#    $self->multistates_graph($self->get_structure_multistates_graph());
#}

sub multistates_graph {
    my ($self, @meta) = @_;

    my %meta = ref($meta[0]) eq 'HASH' ? %{$meta[0]} : @meta;    # TODO: remove copying here

    my $package = blessed($self) // $self;
    throw gettext("Package name must be QBit::Application::Model::Multistate descendant")
      if !$package || ref($package) || !$package->isa('QBit::Application::Model::Multistate');

    # When this sub is called for an object store in the object.
    # When this sub is called for a package store in that package stash.
    #
    my $storage = defined(blessed($self)) ? $self : package_stash($self);

    my $bit_num = 0;
    throw gettext('Max multistates count is 63')
      if @{$meta{'multistates'} || []} > 63;

    $storage->{'__MULTISTATES_GRAPH_DEFINITION__'} = clone(\%meta);

    $storage->{'__EMPTY_NAME__'} = $meta{'empty_name'} || gettext('Start status');

    $storage->{'__BITS__'} = [map {[shift(@$_), shift(@$_), {@$_}]} @{$meta{'multistates'} || []}];

    $storage->{'__BITS_HS__'} =
      {map {$_->[0] => {bit => $bit_num++, description => $_->[1], opts => $_->[2]}} @{$storage->{'__BITS__'}}};

    $storage->{'__ACTIONS__'} = {};
    my %actions = (%{$meta{'actions'} || {}}, %{$meta{'right_actions'} || {}});
    while (my ($key, $value) = each(%actions)) {
        my $label;
        if (ref($value) eq 'HASH') {
            $label = $value->{'label'};
            $storage->{'__DONT_LOG_ACTIONS__'}{$key} = TRUE
              if $value->{'dont_write_to_action_log'};
        } else {
            $label = $value;
        }
        $storage->{'__ACTIONS__'}{$key} = $label;
    }

    $storage->{'__RIGHT_ACTIONS__'} = {};
    my %right_group = (
        (
            exists($meta{'right_group'})
            ? (
                name        => $meta{'right_group'}[0],
                description => $meta{'right_group'}[1]
              )
            : ()
        ),
        rights => {}
    );
    foreach my $action (keys(%{$meta{'right_actions'} || {}})) {
        my $right_name = 'do_' . ($meta{'right_name_prefix'} || '') . $action;
        $storage->{'__RIGHT_ACTIONS__'}{$action} = $right_name;
        my $value = $meta{'right_actions'}->{$action};
        my $label = ref($value) eq 'HASH' ? $value->{'label'} : $value;
        $right_group{'rights'}->{$right_name} = sub {gettext('Right to do action "%s"', $label->())};
    }

    if (defined(blessed($self))) {
        $self->register_rights([\%right_group]);
    } else {
        __PACKAGE__->register_rights([\%right_group]);
    }

    $storage->{'__MULTISTATES__'} = {0 => {}};
    my $prev_multistates_cnt;

    while (!$prev_multistates_cnt || $prev_multistates_cnt != keys(%{$storage->{'__MULTISTATES__'}})) {
        $prev_multistates_cnt = keys(%{$storage->{'__MULTISTATES__'}});
        foreach my $action (@{$meta{'multistate_actions'} || []}) {
            throw gettext('Unknown action "%s"', $action->{'action'})
              unless exists($storage->{'__ACTIONS__'}{$action->{'action'}});

            foreach my $multistate (
                __filter_multistates($storage->{'__BITS_HS__'}, $storage->{'__MULTISTATES__'}, $action->{'from'}))
            {
                my $new_multistate = $multistate;
                $new_multistate |= 2**$storage->{'__BITS_HS__'}{$_}{'bit'} foreach @{$action->{set_flags} || []};

                $new_multistate &= ~(2**$storage->{'__BITS_HS__'}{$_}{'bit'}) foreach @{$action->{reset_flags} || []};

                $storage->{'__MULTISTATES__'}{$multistate}{$action->{'action'}} = $new_multistate;

                $storage->{'__MULTISTATES__'}{$new_multistate} = {}
                  unless exists($storage->{'__MULTISTATES__'}{$new_multistate});
            }
        }
    }

    # Check the multistates graph for unreachable statuses.

    my @unreachable;
    foreach my $multistate_name (keys(%{$storage->{'__BITS_HS__'}})) {
        next
          if $storage->{'__BITS_HS__'}{$multistate_name}{'opts'}{'deprecated'};

        my $multistate = $storage->{'__BITS_HS__'}{$multistate_name};

        my $exists = $storage->{'__MULTISTATES__'}{$multistate->{'bit'}};
        unless ($exists) {
            foreach (keys(%{$storage->{'__MULTISTATES__'}})) {
                if (($_ & 2**$multistate->{'bit'})) {
                    $exists = TRUE;
                    last;
                }
            }
        }
        push(@unreachable, $multistate_name) unless $exists;
    }

    throw gettext("Unreachable status(es) in package '%s': '%s'.", $package, join(q{', '}, @unreachable)),
      if @unreachable;
}

sub get_structure_multistates_graph {return {}}

__PACKAGE__->mk_ro_self_or_stash_accessors(
    {
        _get_empty_name                  => '__EMPTY_NAME__',
        get_multistates_graph_definition => '__MULTISTATES_GRAPH_DEFINITION__',
        get_multistates                  => '__MULTISTATES__',
        get_multistates_bits             => '__BITS__',
        get_multistates_bits_hs          => '__BITS_HS__',
        get_registered_actions           => '__ACTIONS__',
        get_registered_actions_rights    => '__RIGHT_ACTIONS__',
    }
);

sub check_multistate_action {
    my ($self, $multistate, $action) = @_;

    return FALSE
      unless exists($self->get_multistates()->{$multistate})
          && exists($self->get_multistates()->{$multistate}{$action});

    my $right = $self->get_registered_actions_rights->{$action};
    return FALSE if defined($right) && !$self->check_rights($right);

    return TRUE;
}

sub check_multistate_flag {
    my ($self, $multistate, $flag) = @_;

    my $bits_hs = $self->get_multistates_bits_hs()->{$flag} || return FALSE;

    return !!(($multistate || 0) & (2**$bits_hs->{'bit'}));
}

sub get_action_name {
    my ($self, $action) = @_;

    my $action_name = $self->get_registered_actions()->{$action};
    $action_name = $action_name->()
      if ref($action_name) eq 'CODE';

    return $action_name;
}

sub get_all_available_multistate_actions {
    my ($self) = @_;

    my %actions = ();

    my $registered_actions        = $self->get_registered_actions();
    my $registered_actions_rights = $self->get_registered_actions_rights();

    foreach (sort keys(%{$registered_actions})) {
        if (my $right = $registered_actions_rights->{$_}) {
            next unless $self->check_rights($right);
        }

        $actions{$_} = $registered_actions->{$_}->();
    }

    return \%actions;
}

sub get_empty_name {
    my ($self) = @_;

    my $name = $self->_get_empty_name();

    return ref($name) eq 'CODE' ? $name->() : $name;
}

sub get_multistate_actions {
    my ($self, $multistate) = @_;

    return {
        map {$_ => $self->get_action_name($_)}
          grep {$self->check_multistate_action($multistate, $_)}
          keys(%{$self->get_multistates()->{$multistate} || {}})
    };
}

sub get_multistate_by_action {
    my ($self, $action) = @_;

    my $multistates = $self->get_multistates();

    return [sort {$a <=> $b} grep {exists($multistates->{$_}{$action})} keys(%$multistates)];
}

# Get multistate value by name
sub get_multistate_by_name {
    my ($self, $name) = @_;

    my $multistate_names = $self->get_multistate_names();
    my $multistate       = $multistate_names->{$name};
    return defined($multistate) ? $multistate + 0 : undef;
}

# Get multistate names: { <name> => <val>, ... }
sub get_multistate_names {
    my ($self) = @_;

    my $multistate_bits  = $self->get_multistate_bits();
    my $multistate_names = {reverse %$multistate_bits};

    return $multistate_names;
}

# Get multistate bits: { <val> => <name>, ... }
sub get_multistate_bits {
    my ($self) = @_;

    my $bits = $self->get_multistates_bits();

    my $i = -1;
    my $multistate_bits = {map {2** ++$i => $bits->[$i]->[0]} @$bits};

    return $multistate_bits;
}

sub get_multistate_name {
    my ($self, $multistate, %opts) = @_;

    return $self->get_empty_name() if $multistate == 0;

    my $i = 0;

    my $name = join(
        ".\n",
        map {ref($_->[1]) eq 'CODE' ? $_->[1]() : $_->[1]}
          grep {
                 ($multistate & 2**$i++) == 2**($i - 1)
              && ($opts{'private'} && $_->[2]{'private'} || !$_->[2]{'private'})
          } @{$self->get_multistates_bits()}
    );

    $name = $self->get_empty_name() unless length($name);

    return $name;
}

sub get_multistate_name_as_list {
    my ($self, $multistate, %opts) = @_;

    return $self->get_empty_name() if $multistate == 0;

    my %filter;
    %filter = map {$_ => TRUE} @{$opts{'filter'}} if $opts{'filter'};

    my $show_private = $opts{'private'};

    my $i = 0;
    my @names = map {ref($_->[1]) eq 'CODE' ? $_->[1]() : $_->[1]}
      grep {
             ($multistate & 2**$i++) == 2**($i - 1)
          && (!%filter || $filter{$_->[0]})
          && ($show_private || !$_->[2]{'private'})
      } @{$self->get_multistates_bits()};

    return $self->get_empty_name() unless @names;
    return @names;
}

sub get_multistates_by_filter {
    my ($self, $filter) = @_;

    return [__filter_multistates($self->get_multistates_bits_hs(), $self->get_multistates(), $filter)];
}

sub get_rights_by_actions {
    my ($self, @actions) = @_;

    my $right_name_prefix = $self->get_multistates_graph_definition()->{'right_name_prefix'};

    return (defined($right_name_prefix) ? (map {"do_$right_name_prefix" . $_} @actions) : ());
}

sub __filter_multistates {
    my ($bits, $multistates, $expression) = @_;

    my %operators = (
        OR  => [0, sub {'(' . pop(@{$_[0]}) . ' || ' . pop(@{$_[0]}) . ')'}],
        AND => [1, sub {'(' . pop(@{$_[0]}) . ' && ' . pop(@{$_[0]}) . ')'}],
        NOT => [2, sub {'!' . pop(@{$_[0]})}],
    );

    my $process = sub {
        my ($op, $Q) = @_;

        push(@$Q, $operators{$op}->[1]($Q));
    };

    my $qexpression = "($expression)";
    my (@Q, @W);
    while ($qexpression =~ /(\(|\)|[a-zA-Z0-9_]+)/g) {
        my $token = $1;

        if ($token eq '(') {
            push(@W, '(');
        } elsif ($token eq ')') {
            while (@W) {
                my $operator = pop(@W);
                last if $operator eq '(';
                $process->($operator, \@Q);
            }
        } elsif (exists($operators{uc($token)})) {
            my $operator = pop(@W);
            ($operators{uc($token)}->[0] || 0) < ($operators{$operator}->[0] || 0)
              ? $process->($operator, \@Q)
              : push(@W, $operator);

            push(@W, uc($token));
        } else {
            throw Exception::Multistate gettext('Status "%s" does not exists', $token)
              unless exists($bits->{$token}) || $token eq '__EMPTY__';
            push(@Q,
                $token eq '__EMPTY__'
                ? '($_[0] == 0)'
                : '(($_[0] & ' . 2**$bits->{$token}{'bit'} . ') == ' . 2**$bits->{$token}{'bit'} . ')');
        }
    }

    my $sub_text = 'sub {' . pop(@Q) . '}';

    throw Exception::Multistate gettext('Syntax error in expression "%s"', $expression) if @W + @Q;

    my $sub = eval($sub_text);

    return sort {$a <=> $b} grep {$sub->($_)} keys(%$multistates);
}

TRUE;
