package QBit::Application::Model::Yandex::CookieMy;

use strict;
use warnings FATAL => 'all';
use utf8;

use base qw(Exporter);
use MIME::Base64;

our @EXPORT = qw(parse_cookie_my);
# our @EXPORT_OK = @EXPORT;
#
# sub PervertSetup($);
# sub unmarshal($);

sub parse_cookie_my {
    my ($mycookie) = @_;
    $mycookie =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    my $setuphash = PervertSetup(unmarshal($mycookie));
    return $setuphash;
}

sub PervertSetup($) {
    my $Setup = shift;
    my %ret;

    for my $Col (0 .. $#{$Setup}) {
        my $BlocksInCol = $#{$Setup->[$Col]};
        for my $BlockNo (0 .. $BlocksInCol) {
            my $blockSetup      = $Setup->[$Col]->[$BlockNo];
            my $BlockID         = $blockSetup->[0];
            my $blockSetupCount = $#{$blockSetup};

            if ($blockSetupCount > 0) {
                $ret{$BlockID} = $blockSetup;
                shift @{$ret{$BlockID}};
            }
            undef $blockSetupCount;
            undef $blockSetup;
            undef $BlockID;
        }
        undef $BlocksInCol;
    }

    undef $Setup;

    #$dumper->dumpValue(\%ret);
    return \%ret;
}

sub unmarshal($) {
    my $Data = shift;
    my $Setup;

    # check old style cookie
    if (index($Data, ':') != -1) {
        return undef;
    }

    $Data = decode_base64($Data);

    return undef unless substr($Data, 0, 1) eq 'c';
    $Setup = [];    # unless ref($Setup) eq 'ARRAY';

    my $DataLen = length($Data);
    #print "Unmarshal $DataLen bytes.\n";

    my $Column    = 0;
    my $ColumnPos = 0;
    my $Index     = 1;    # skip first 'z'

    my $BlockID = 0;
    my $BlockSetupCount;
    my $i;
    while ($Index < $DataLen) {
        #unmarshal first byte with block id.
        $BlockID = unpack('C', substr($Data, $Index, 1));
        $Index++;
        if ($BlockID == 0) {
            # Got column separator.
            $Column++;
            $ColumnPos = 0;
            #print "Switch to column $Column\n";
        } else {
            #print "Got Block $BlockID\n";
            $Setup->[$Column] = [] unless defined $Setup->[$Column];
            $Setup->[$Column]->[$ColumnPos] = [] unless defined $Setup->[$Column]->[$ColumnPos];
            $Setup->[$Column]->[$ColumnPos]->[0] = $BlockID;
            $BlockSetupCount = unpack('C', substr($Data, $Index, 1));
            $Index++;

            #print "Got $BlockSetupCount fields\n";
            for $i (0 .. $BlockSetupCount - 1) {
                my $firstByte = unpack('C', substr($Data, $Index, 1));
                if ($firstByte < 0x80) {
                    push @{$Setup->[$Column]->[$ColumnPos]}, $firstByte;
                    $Index++;
                } elsif ($firstByte < 0xC0) {
                    #two bytes
                    push @{$Setup->[$Column]->[$ColumnPos]}, unpack('n', substr($Data, $Index, 2)) & 0x3FFF;
                    $Index += 2;
                }
                #elsif($Value < 0x100000){ 0xE0
                #    #3 bytes 1C00000
                #    my ($lo, $high);
                #    $lo = $Value & 0xFFFF;
                #    $high = $Value >> 16;
                #    $str .= pack('C', $high & 0x1C0);
                #    $str .= pack('S', $lo);
                #}
                elsif ($firstByte < 0xF0) {
                    #4 bytes
                    push @{$Setup->[$Column]->[$ColumnPos]}, unpack('N', substr($Data, $Index, 4)) & 0xFFFFFFF;
                    $Index += 4;
                }

                #push @{$Setup->[$Column]->[$ColumnPos]}, unpack('s', substr($Data, $Index, 2));
                #$Index += 2;
            }

            $ColumnPos++;
        }

        #        $Index++;
    }
    return $Setup;
}

1;
